package com.floreantpos.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.beanutils.BeanUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMenuItemModifierPage;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "modifierSpec" })
public class MenuItemModifierPage extends BaseMenuItemModifierPage implements TimedModel {
	private static final long serialVersionUID = 1L;

	private Map<String, MenuItemModifierPageItem> cellItemMap;
	private MenuItemModifierSpec modifierSpec;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public MenuItemModifierPage () {
    }

	/**
	 * Constructor for primary key
	 */
	public MenuItemModifierPage (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public MenuItemModifierPage (
		java.lang.String id,
		java.lang.String name) {

		super (
			id,
			name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public Integer getButtonWidth() {
		Integer buttonWidth = super.getButtonWidth();
		if (buttonWidth < 30) {
			return 30;
		}
		return buttonWidth;
	}

	@Override
	public Integer getButtonHeight() {
		Integer buttonHeight = super.getButtonHeight();
		if (buttonHeight < 30) {
			return 30;
		}
		return buttonHeight;
	}

	public MenuItemModifierPageItem getItemForCell(int col, int row) {
		List<MenuItemModifierPageItem> pageItems = getPageItems();
		if (pageItems == null || pageItems.size() == 0) {
			return null;
		}
		if (cellItemMap == null) {
			cellItemMap = new HashMap<String, MenuItemModifierPageItem>();
			for (MenuItemModifierPageItem menuPageItem : pageItems) {
				String cellKey = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
				cellItemMap.put(cellKey, menuPageItem);
			}
		}
		String cellKey = String.valueOf(col) + String.valueOf(row);
		return cellItemMap.get(cellKey);
	}

	@Override
	public String toString() {
		return super.getName();
	}

	public void setModifierSpec(MenuItemModifierSpec modifierSpec) {
		this.modifierSpec = modifierSpec;
		setModifierSpecId(modifierSpec == null ? null : modifierSpec.getId());
	}

	@XmlTransient
	public MenuItemModifierSpec getModifierSpec() {
		//		if (this.modifierSpec != null) {
		//			return this.modifierSpec;
		//		}
		//		if (StringUtils.isNotEmpty(getModifierSpecId())) {
		//			return MenuItemModifierSpecDAO.getInstance().get(getModifierSpecId());
		//		}
		//		return null;
		return this.modifierSpec;
	}

	public MenuItemModifierPage deepClone() throws Exception {
		MenuItemModifierPage newPage = new MenuItemModifierPage();
		BeanUtils.copyProperties(newPage, this);
		List<MenuItemModifierPageItem> pageItems2 = getPageItems();
		if (pageItems2 == null) {
			return newPage;
		}
		newPage.setId(null);
		newPage.setPageItems(null);
		for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems2) {
			MenuItemModifierPageItem newItem = new MenuItemModifierPageItem();
			BeanUtils.copyProperties(newItem, menuItemModifierPageItem);
			newItem.setId(null);
			newPage.addTopageItems(newItem);
		}
		return newPage;

	}
	
	public Boolean getFlixibleButtonSize() {
		return super.isFlixibleButtonSize();
	}
}