package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;

/**
 * This is an object that contains data related to the INVENTORY_UNIT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_UNIT"
 */

public abstract class BaseInventoryUnit implements Comparable, Serializable {

	public static String REF = "InventoryUnit"; //$NON-NLS-1$
	public static String PROP_CONVERSION_RATE = "conversionRate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_UNIT_TYPE = "unitType"; //$NON-NLS-1$
	public static String PROP_PRODUCT_TYPE = "productType"; //$NON-NLS-1$
	public static String PROP_BASE_UNIT = "baseUnit"; //$NON-NLS-1$
	public static String PROP_UNIT_GROUP_ID = "unitGroupId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CODE = "code"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$

	// constructors
	public BaseInventoryUnit() {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryUnit(java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseInventoryUnit (
		java.lang.String id,
		java.lang.String code) {

		this.setId(id);
		this.setCode(code);
		initialize();
	}

	protected void initialize () {}

	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.String code;
	private java.lang.String name;
	private java.lang.String productType;
	private java.lang.String unitType;
	private java.lang.Boolean baseUnit;
	private java.lang.Double conversionRate;
	private java.lang.String unitGroupId;
	private java.lang.String properties;
	private java.lang.Boolean deleted;

	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId() {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId(java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion() {
		return version;
	}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
	public void setVersion(long version) {
		this.version = version;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime(java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime(java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: CODE
	 */

	public java.lang.String getCode() {
		return code;
	}

	/**
	 * Set the value related to the column: CODE
	 * @param code the CODE value
	 */
	public void setCode(java.lang.String code) {
		this.code = code;
	}

	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName() {
		return name;
	}

	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
	public void setName(java.lang.String name) {
		this.name = name;
	}

	/**
	 * Return the value associated with the column: PRODUCT_TYPE
	 */

	public java.lang.String getProductType() {
		return productType;
	}

	/**
	 * Set the value related to the column: PRODUCT_TYPE
	 * @param productType the PRODUCT_TYPE value
	 */
	public void setProductType(java.lang.String productType) {
		this.productType = productType;
	}

	/**
	 * Return the value associated with the column: UNIT_TYPE
	 */

	public java.lang.String getUnitType() {
		return unitType;
	}

	/**
	 * Set the value related to the column: UNIT_TYPE
	 * @param unitType the UNIT_TYPE value
	 */
	public void setUnitType(java.lang.String unitType) {
		this.unitType = unitType;
	}

	/**
	 * Return the value associated with the column: BASE_UNIT
	 */

	public java.lang.Boolean isBaseUnit() {
		return baseUnit == null ? Boolean.FALSE : baseUnit;
	}

	public java.lang.Boolean getBaseUnit() {
		return baseUnit == null ? Boolean.FALSE : baseUnit;
	}

	/**
	 * Set the value related to the column: BASE_UNIT
	 * @param baseUnit the BASE_UNIT value
	 */
	public void setBaseUnit(java.lang.Boolean baseUnit) {
		this.baseUnit = baseUnit;
	}

	/**
	 * Return the value associated with the column: CONVERSION_RATE
	 */

	public java.lang.Double getConversionRate() {
		return conversionRate == null ? Double.valueOf(0) : conversionRate;
	}

	/**
	 * Set the value related to the column: CONVERSION_RATE
	 * @param conversionRate the CONVERSION_RATE value
	 */
	public void setConversionRate(java.lang.Double conversionRate) {
		this.conversionRate = conversionRate;
	}

	/**
	 * Return the value associated with the column: UNIT_GROUP_ID
	 */

	public java.lang.String getUnitGroupId() {
		return unitGroupId;
	}

	/**
	 * Set the value related to the column: UNIT_GROUP_ID
	 * @param unitGroupId the UNIT_GROUP_ID value
	 */
	public void setUnitGroupId(java.lang.String unitGroupId) {
		this.unitGroupId = unitGroupId;
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted(java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue() {
		return "false";
	}

	public boolean equals(Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.InventoryUnit)) return false;
		else {
			com.floreantpos.model.InventoryUnit inventoryUnit = (com.floreantpos.model.InventoryUnit) obj;
			if (null == this.getId() || null == inventoryUnit.getId()) return this == obj;
			else return (this.getId().equals(inventoryUnit.getId()));
		}
	}

	public int hashCode() {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo(Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString() {
		return super.toString();
	}

}