package com.floreantpos.model;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;

public class SurgeryMedicineItem {

	private String medicineItemId;
	private String medicineItemName;
	private double quantity;
	private String unitId;
	private String unitName;
	private String unitType;
	private String status;

	private transient MenuItem medicineItem;

	public SurgeryMedicineItem() {

	}

	public String getMedicineItemId() {
		return medicineItemId;
	}

	public void setMedicineItemId(String medicineItemId) {
		this.medicineItemId = medicineItemId;
	}

	public String getMedicineItemName() {
		return medicineItemName;
	}

	public void setMedicineItemName(String medicineItemName) {
		this.medicineItemName = medicineItemName;
	}

	public double getQuantity() {
		return quantity;
	}

	public void setQuantity(double quantity) {
		this.quantity = quantity;
	}

	public IUnit getUnit() {
		return DataProvider.get().getUnitById(unitId, unitType);
	}

	public void setUnit(IUnit iunit) {
		if (iunit != null) {
			setUnitId(iunit.getId());
			setUnitName(iunit.getDisplayName());
			setUnitType(iunit.getUnitType());
		}
		else {
			setUnitId(null);
			setUnitName(null);
			setUnitType(null);
		}
	}

	public String getUnitId() {
		return unitId;
	}

	public void setUnitId(String unitId) {
		this.unitId = unitId;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	public String getUnitType() {
		return unitType;
	}

	public void setUnitType(String unitType) {
		this.unitType = unitType;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public MenuItem getMedicineItem() {
		return medicineItem;
	}

	public void setMedicineItem(MenuItem medicineItem) {
		this.medicineItem = medicineItem;
	}

	public String getQuantityDisplay() {
		String quantity = NumberUtil.formatNumberIfNeeded(getQuantity());
		String unitName = getUnitName();
		return quantity + " " + (StringUtils.isBlank(unitName) ? "" : unitName);
	}

	@Override
	public String toString() {
		return getMedicineItemName();
	}

}
