package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum DurationType {
	// @formatter:off
	DAY("Day"),
	MONTH("Month"),
	YEAR("Year");
	// @formatter:on

	private final String displayName;

	DurationType(String displayName) {
		this.displayName = displayName;
	}

	public static DurationType fromString(String typeName) {
		if (StringUtils.isBlank(typeName)) {
			return null;
		}
		DurationType[] durations = values();
		for (DurationType duration : durations) {
			if (duration.name().equalsIgnoreCase(typeName)) {
				return duration;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return displayName;
	}
}