package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the STORE_RATING table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="STORE_RATING"
 */

public abstract class BaseStoreRating  implements Comparable, Serializable {

	public static String REF = "StoreRating"; //$NON-NLS-1$
	public static String PROP_RATING_DATE = "ratingDate"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_COMMENTS = "comments"; //$NON-NLS-1$
	public static String PROP_RATING = "rating"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseStoreRating () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseStoreRating (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String customerId;
				private java.lang.String storeId;
				private java.util.Date ratingDate;
				private java.lang.Integer rating;
				private java.lang.String comments;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: RATING_DATE
	 */

	public java.util.Date getRatingDate () {
			return ratingDate;
	}



	/**
	 * Set the value related to the column: RATING_DATE
	 * @param ratingDate the RATING_DATE value
	 */
			public void setRatingDate (java.util.Date ratingDate) {
			this.ratingDate = ratingDate;
	}



	/**
	 * Return the value associated with the column: RATING
	 */

	public java.lang.Integer getRating () {
						return rating == null ? Integer.valueOf(0) : rating;
		}



	/**
	 * Set the value related to the column: RATING
	 * @param rating the RATING value
	 */
			public void setRating (java.lang.Integer rating) {
			this.rating = rating;
	}



	/**
	 * Return the value associated with the column: COMMENTS
	 */

	public java.lang.String getComments () {
			return comments;
	}



	/**
	 * Set the value related to the column: COMMENTS
	 * @param comments the COMMENTS value
	 */
			public void setComments (java.lang.String comments) {
			this.comments = comments;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.StoreRating)) return false;
		else {
			com.floreantpos.model.StoreRating storeRating = (com.floreantpos.model.StoreRating) obj;
			if (null == this.getId() || null == storeRating.getId()) return this == obj;
			else return (this.getId().equals(storeRating.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}