/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseActionHistory;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "objectReference" })
@XmlRootElement
public class ActionHistory extends BaseActionHistory implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	private Object objectReference;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ActionHistory() {
	}

	/**
	 * Constructor for primary key
	 */
	public ActionHistory(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public final static String SMS_SENT = "SMS SENT"; //$NON-NLS-1$
	public final static String EMIL_SENT = "EMIL SENT"; //$NON-NLS-1$
	public final static String ENABLE_SMS_REQUEST  = "Enable SMS request"; //$NON-NLS-1$
	public final static String ENABLE_EMAIL_REQUEST = "Enable Email request"; //$NON-NLS-1$
	public final static String ENABLE_SMS = "Enable SMS"; //$NON-NLS-1$
	public final static String ENABLE_EMAIL = "Enable Email"; //$NON-NLS-1$
	public final static String DISABLE_SMS = "Disable SMS"; //$NON-NLS-1$
	public final static String DISABLE_EMAIL = "Disable Email"; //$NON-NLS-1$
	public final static String MQTT_CHECK = "Mqtt ticket save"; //$NON-NLS-1$
	public final static String NEW_CHECK = "New order"; //$NON-NLS-1$
	public final static String SAVE_CHECK = "Save order"; //$NON-NLS-1$
	public final static String EDIT_CHECK = "Edit order"; //$NON-NLS-1$
	public final static String SPLIT_CHECK = "Split order"; //$NON-NLS-1$
	public final static String VOID_CHECK = "Void order"; //$NON-NLS-1$
	public static final String VOID_PAYMENT = "Void payment"; //$NON-NLS-1$
	public final static String NEW_PURCHASE_ORDER = "New purchase order"; //$NON-NLS-1$
	public final static String TICKET_ITEM_VOID = "Order item void"; //$NON-NLS-1$
	public final static String REOPEN_CHECK = "Reopen order"; //$NON-NLS-1$
	public final static String SETTLE_CHECK = "Settle order"; //$NON-NLS-1$
	public final static String REFUND_CHECK = "Refund order"; //$NON-NLS-1$
	public final static String PRINT_CHECK = "Print receipt"; //$NON-NLS-1$
	public final static String PAY_CHECK = "Pay order"; //$NON-NLS-1$
	public final static String GROUP_SETTLE = "Group settle"; //$NON-NLS-1$
	public final static String PAY_OUT = "Pay out"; //$NON-NLS-1$
	public final static String EXPENSES = "Expenses"; //$NON-NLS-1$
	public final static String SALARY = "Salary"; //$NON-NLS-1$
	public final static String RF_PAY = "RF pay"; //$NON-NLS-1$
	public final static String LDF_PAY = "LDF pay"; //$NON-NLS-1$
	public final static String PAY_TIPS = "Pay tips"; //$NON-NLS-1$
	public final static String STAFF_BANK_FORCE_CLOSE = "Staff bank force close";//$NON-NLS-1$
	public final static String TRANSFER_TICKET = "Transfer ticket"; //$NON-NLS-1$
	public final static String SENT_TO_KITCHEN = "Sent to kitchen"; //$NON-NLS-1$
	public final static String FORCED_CLOCK_OUT = "Forced clock out"; //$NON-NLS-1$
	public final static String CLOCK_IN = "Clock in"; //$NON-NLS-1$
	public final static String CLOCK_OUT = "Clock out"; //$NON-NLS-1$
	public final static String DATE_CHAGE = "Order create date change"; //$NON-NLS-1$
	public final static String CUSTOMER_SET = "Customer set"; //$NON-NLS-1$
	public final static String CUSTOMER_REMOVED = "Customer removed"; //$NON-NLS-1$
	public final static String MERGE_TICKET = "Merge ticket"; //$NON-NLS-1$
	public final static String TRANSFER_ITEMS = "Transfer items"; //$NON-NLS-1$
	public final static String TABLE_CHANGE = "Table change"; //$NON-NLS-1$
	public final static String TABLE_ADDED = "Table added"; //$NON-NLS-1$
	public final static String TABLE_RELEASED = "Table released"; //$NON-NLS-1$
	public static final String SALES_AREA_CHANGE = "Sales area change"; //$NON-NLS-1$
	public static final String ORDER_HOLD = "Hold order"; //$NON-NLS-1$
	public static final String CASH_DRAWER_CLOSE = "Cash drawer close"; //$NON-NLS-1$
	public static final String CASH_DRAWER_ASSIGNMENT = "Cash drawer assignment"; //$NON-NLS-1$
	public static final String CLOSE_TICKET = "Close order"; //$NON-NLS-1$
	public static final String TICKET_DISCOUNT_ADDED = "Order discount added"; //$NON-NLS-1$
	public static final String ITEM_DISCOUNT_ADDED = "Item discount added"; //$NON-NLS-1$
	public static final String LOYALTY_ADDED = "Loyalty added"; //$NON-NLS-1$
	public static final String TICKET_DISCOUNT_REMOVED = "Order discount removed"; //$NON-NLS-1$
	public static final String ITEM_DISCOUNT_REMOVED = "Item discount removed"; //$NON-NLS-1$
	public static final String LOYALTY_REMOVED = "Loyalty removed"; //$NON-NLS-1$
	public static final String GRATUITY_ADDED = "Gratuity set"; //$NON-NLS-1$
	public static final String SF_SYNC_GRATUITY_CHANGE = "Sf sync gratuity amount change"; //$NON-NLS-1$
	public static final String TAX_EXEMPT = "Tax exempt"; //$NON-NLS-1$
	public static final String TAX_UNEXEMPT = "Tax unexempt";//$NON-NLS-1$
	public static final String CASH_DRAWER_BLEED = "Cash drawer bleed"; //$NON-NLS-1$
	public static final String CASH_DRAWER_TRANSFER_USER = "Cash drawer assignment change"; //$NON-NLS-1$

	public static final String USER_CREATED = "user created"; //$NON-NLS-1$
	public static final String USER_MODIFIED = "user modified"; //$NON-NLS-1$
	public static final String USER_DELETED = "user deleted"; //$NON-NLS-1$

	public static final String TICKET_DELETED = "Ticket deleted"; //$NON-NLS-1$

	public static final String ADJUST_INVENTORY_ON_HAND = "Adjust inventory on hand"; //$NON-NLS-1$
	public static final String PURCHASE_ITEM_ADDED = "Purchase Item added"; //$NON-NLS-1$
	public static final String PURCHASE_ITEM_EDITED = "Purchase Item edited"; //$NON-NLS-1$
	public static final String PURCHASE_ITEM_DELETED = "Purchase Item deleted"; //$NON-NLS-1$
	public static final String ITEM_ADDED = "Item added"; //$NON-NLS-1$
	public static final String ITEM_EDITED = "Item edited"; //$NON-NLS-1$
	public static final String ITEM_DELETED = "Item deleted"; //$NON-NLS-1$
	public static final String PATIENT_ADDED = "Patient added"; //$NON-NLS-1$
	public static final String PATIENT_DELETED = "Patient deleted"; //$NON-NLS-1$
	public static final String DOCTOR_ADDED = "Doctor added"; //$NON-NLS-1$
	public static final String REFERRER_ADDED = "Referrer added"; //$NON-NLS-1$
	public static final String REFERRER_CHANGED = "Changed referrer"; //$NON-NLS-1$
	public static final String OPEN_REGISTER = "Open register"; //$NON-NLS-1$
	public static final String CLOSE_REGISTER = "Close register"; //$NON-NLS-1$
	public static final String USER_LOGIN = "User Login"; //$NON-NLS-1$
	public static final String USER_LOGOUT = "User Logout"; //$NON-NLS-1$
	public static final String LAB_INCHARGE_ADDED = "Lab incharge added"; //$NON-NLS-1$
	public static final String ORDER_INFO = "VIEW ORDER INFO"; //$NON-NLS-1$
	public static final String RECIPE_ITEMS_PRINT = "RECIPE ITEMS PRINT"; //$NON-NLS-1$
	public static final String DONT_UPDATE_RECIPE_ITEMS = "DON'T UPDATE RECIPE ITEMS"; //$NON-NLS-1$
	public static final String VIEW_REPORT = "VIEW REPORT"; //$NON-NLS-1$
	public static final String PRINT_LAB_REPORT = "PRINT LAB REPORT"; //$NON-NLS-1$
	public static final String PRINT_INVOICE = "PRINT INVOICE"; //$NON-NLS-1$
	public static final String PRINT_STICKER = "PRINT STICKER"; //$NON-NLS-1$
	public static final String CLOSE_ORDER = "CLOSE ORDER"; //$NON-NLS-1$

	public static final String CREATE_CUSTOMER = "Customer created"; //$NON-NLS-1$
	public static final String EDIT_CUSTOMER = "Customer Edited"; //$NON-NLS-1$
	public static final String CREATE_PATIENT = "Patient created"; //$NON-NLS-1$
	public static final String EDIT_PATIENT = "Patient Edited"; //$NON-NLS-1$
	public static final String CREATE_DOCTOR = "Doctor created"; //$NON-NLS-1$
	public static final String EDIT_DOCTOR = "Doctor edited"; //$NON-NLS-1$
	public static final String DOCTOR_DELETED = "Doctor deleted"; //$NON-NLS-1$
	public static final String CREATE_AGENT = "Agent created"; //$NON-NLS-1$
	public static final String EDIT_AGENT = "Agent edited"; //$NON-NLS-1$
	public static final String AGENT_DELETED = "Agent deleted"; //$NON-NLS-1$
	public static final String USER_PASSWORD_CHANGED = "User password changed"; //$NON-NLS-1$
	public static final String USER_PIN_CHANGED = "User pin changed"; //$NON-NLS-1$

	public static final String PRICE_UPDATED = "Price updated due to RF change"; //$NON-NLS-1$

	public static final String APPOINTMENT_DELETED = "Appointment deleted"; //$NON-NLS-1$
	public static final String CREATE_APPOINTMENT = "Appointment created"; //$NON-NLS-1$
	public static final String EDIT_APPOINTMENT = "Appointment edited"; //$NON-NLS-1$

	public enum ActionType {
		//@formatter:off
		SHARED_ITEM_CALCULATION("Shared Item Calculation"), 
		SMS_SENT("SMS sent"), 
		EMIL_SENT("Email sent"), 
		OTP("Otp"), 
		NOTIFICATION("Notification"), 
		NOTIFICATION_SERVICE("Notification service")
		;
		//@formatter:on
		private String displayName;

		ActionType(String displayName) {
			this.displayName = displayName;
		}

		public String getDisplayName() {
			return displayName;
		}

		@Override
		public String toString() {
			return displayName;
		}
	}

	@XmlTransient
	public Object getObjectReference() {
		return objectReference;
	}

	public void setObjectReference(Object objectReference) {
		this.objectReference = objectReference;
	}

	public static ActionHistory create(String action, String description, User user, String outletId) {
		return create(null, action, description, user, outletId);
	}

	public static ActionHistory create(Ticket ticket, String action, String description, User user, String outletId) {
		return createHistory(ticket == null ? null : ticket.getId(), action, description, user, outletId);
	}

	public static ActionHistory createHistory(String orderId, String action, String description, User user, String outletId) {
		ActionHistory history = new ActionHistory();
		if (orderId != null) {
			history.setTicketId(orderId);
		}
		history.setActionName(action);
		history.setDescription(description);
		history.setPerformer(user);
		history.setOutletId(outletId);
		history.setActionTime(StoreDAO.getServerTimestamp());
		return history;
	}

	public String getActionTimeDisplay() {
		return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(getActionTime()));
	}
}
