/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.Patient;
import com.floreantpos.model.PatientBookingStatus;
import com.floreantpos.model.dao.PatientDAO;

public class UpdateDBTo435 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo435(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		updatePatients();
	}

	public void updatePatients() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		try (Session session = sessionFactory.openSession()) {
			Criteria criteria = session.createCriteria(BookingInfo.class);
			criteria.setProjection(Projections.property(BookingInfo.PROP_CUSTOMER_ID));
			criteria.add(Restrictions.eq(BookingInfo.PROP_DELETED, Boolean.FALSE));
			criteria.add(Restrictions.ne(BookingInfo.PROP_STATUS, PatientBookingStatus.DISCHARGED.name()));
			criteria.add(Restrictions.eq(BookingInfo.PROP_CLOSED, Boolean.FALSE));
			List<String> openBookingPatientIds = criteria.list();
			if (openBookingPatientIds == null) {
				openBookingPatientIds = new ArrayList<>();
			}
			criteria = session.createCriteria(Patient.class);
			criteria.setProjection(Projections.rowCount());

			int totalRecords = ((Long) criteria.uniqueResult()).intValue();
			PosLog.info(UpdateDBTo435.class, "Found total patients: " + totalRecords); //$NON-NLS-1$

			criteria = session.createCriteria(Patient.class);
			criteria.setMaxResults(totalRecords);

			List<Patient> patients = criteria.list();
			Transaction transaction = session.beginTransaction();
			for (Patient patient : patients) {
				patient.setIpdAdmitted(openBookingPatientIds.contains(patient.getId()));
				PatientDAO.getInstance().saveOrUpdate(patient, session);
			}
			transaction.commit();
		}

		PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
	}
}