package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum AccountRole {
	//@formatter:off
	ACCOUNTS_OWNER("Accounts owner"),
	ACCOUNTS_MANAGER("Accounts manager"),
	EXPENSE_OFFICER("Expense officer")
	;
	//@formatter:on

	String displayString;

	private AccountRole(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public AccountRole fromName(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		AccountRole[] values = values();
		for (AccountRole accountRole : values) {
			if (name.equals(accountRole.name())) {
				return accountRole;
			}
		}

		return null;
	}

	public static AccountRole getAccontRole(User user) {
		if (user == null) {
			return null;
		}
		if (user.isAccountsOwner()) {
			return ACCOUNTS_OWNER;
		}
		else if (user.isAccountsManager()) {
			return ACCOUNTS_MANAGER;
		}
		else if (user.isExpenseOfficer()) {
			return EXPENSE_OFFICER;
		}
		return null;
	}

	public static String getAccountRoleDisplay(User user) {
		AccountRole accontRole = getAccontRole(user);
		return accontRole == null ? StringUtils.EMPTY : accontRole.displayString;
	}
}
