package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Block;
import com.floreantpos.swing.PaginatedListModel;

public class BlockDAO extends BaseBlockDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public BlockDAO() {
	}

	public void loadData(PaginatedListModel<Block> tableModel, String name, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(Block.PROP_OUTLET_ID, outletId));
			}
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(name)) {
				criteria.add(Restrictions.eq(Block.PROP_NAME, name));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setData(criteria.list());
		}
	}

	public List<Block> getBlocks(String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(Block.PROP_OUTLET_ID, outletId));
			}
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		Block data = (Block) obj;
		if (data == null) {
			throw new PosException("Data not found.");
		}
		data.setDeleted(Boolean.TRUE);
		saveOrUpdate(data, session);
	}
}