package com.floreantpos;

import org.slf4j.LoggerFactory;

import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;

public class PosLog {

	public static void error(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).error(getSchemaName() + message);
	}

	public static void error(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LoggerFactory.getLogger(eClass).error(getSchemaName() + message, e);
	}

	public static void error(Class<?> eClass, String message, Exception e) {
		LoggerFactory.getLogger(eClass).error(getSchemaName() + message, e);
	}

	public static void debug(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LoggerFactory.getLogger(eClass).debug(getSchemaName() + message, e);
	}

	public static void debug(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).debug(getSchemaName() + message);
	}

	public static void info(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).info(getSchemaName() + message);
	}

	private static String getSchemaName() {
		try {
			DataProvider dataProvider = DataProvider.get();
			if (dataProvider == null) {
				return "";
			}
			Store store = dataProvider.getStore();
			if (store != null) {
				return store.getUuid() + " - ";
			}
		} catch (Exception e) {
		}
		return "";
	}
}
