/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import com.floreantpos.Messages;

public enum CashDrawerType {
	//@formatter:off
	NO_CASH_DRAWER(Messages.getString("CashDrawerType.0")), //$NON-NLS-1$
	SINGLE_CASH_DRAWER(Messages.getString("CashDrawerType.1")), //$NON-NLS-1$
	DUAL_CASH_DRAWER(Messages.getString("CashDrawerType.2")), //$NON-NLS-1$
	;
	//@formatter:on

	private String displayString;

	private CashDrawerType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	public static CashDrawerType getCashDrawerType(String name) {
		for (CashDrawerType cashDrawerType : CashDrawerType.values()) {
			if (cashDrawerType.name().equals(name)) {
				return cashDrawerType;
			}
		}
		return null;
	}
}
