package com.floreantpos.model;

public enum OTStatus {
	//@formatter:off
		REQUESTED("Requested"), 
		DR_APPROVED("Doctor approved"), 
		ORDER_CREATED("Order created"), 
		COMPLETED("Completed"), 
		IN_PROGRESS("In Progress"),
		CANCELED("Canceled")
		;
		//@formatter:on
	private String displayString;

	private OTStatus(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static OTStatus fromNameString(String name) {
		OTStatus[] statusList = values();
		for (OTStatus status : statusList) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return REQUESTED;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}
