package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_BLOOD_DONATION_HISTORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_BLOOD_DONATION_HISTORY"
 */

public abstract class BaseBloodDonationHistory  implements Comparable, Serializable {

	public static String REF = "BloodDonationHistory"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_BLOOD_GROUP = "bloodGroup"; //$NON-NLS-1$
	public static String PROP_DONATION_DATE = "donationDate"; //$NON-NLS-1$
	public static String PROP_VENDOR_ID = "vendorId"; //$NON-NLS-1$
	public static String PROP_HEALTH_STATUS = "healthStatus"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_VOLUME = "volume"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_BLOOD_BAG_NO = "bloodBagNo"; //$NON-NLS-1$
	public static String PROP_PURCHASE_ORDER_ID = "purchaseOrderId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_BLOOD_TYPE = "bloodType"; //$NON-NLS-1$


	// constructors
	public BaseBloodDonationHistory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseBloodDonationHistory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String bloodGroup;
				private java.lang.String bloodType;
				private java.util.Date donationDate;
				private java.lang.String healthStatus;
				private java.lang.Integer quantity;
				private java.lang.Double volume;
				private java.lang.String unit;
				private java.lang.String bloodBagNo;
				private java.lang.String status;
				private java.lang.String purchaseOrderId;
				private java.lang.String vendorId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: BLOOD_GROUP
	 */

	public java.lang.String getBloodGroup () {
			return bloodGroup;
	}



	/**
	 * Set the value related to the column: BLOOD_GROUP
	 * @param bloodGroup the BLOOD_GROUP value
	 */
			public void setBloodGroup (java.lang.String bloodGroup) {
			this.bloodGroup = bloodGroup;
	}



	/**
	 * Return the value associated with the column: BLOOD_TYPE
	 */

	public java.lang.String getBloodType () {
			return bloodType;
	}



	/**
	 * Set the value related to the column: BLOOD_TYPE
	 * @param bloodType the BLOOD_TYPE value
	 */
			public void setBloodType (java.lang.String bloodType) {
			this.bloodType = bloodType;
	}



	/**
	 * Return the value associated with the column: DONATION_DATE
	 */

	public java.util.Date getDonationDate () {
			return donationDate;
	}



	/**
	 * Set the value related to the column: DONATION_DATE
	 * @param donationDate the DONATION_DATE value
	 */
			public void setDonationDate (java.util.Date donationDate) {
			this.donationDate = donationDate;
	}



	/**
	 * Return the value associated with the column: HEALTH_STATUS
	 */

	public java.lang.String getHealthStatus () {
			return healthStatus;
	}



	/**
	 * Set the value related to the column: HEALTH_STATUS
	 * @param healthStatus the HEALTH_STATUS value
	 */
			public void setHealthStatus (java.lang.String healthStatus) {
			this.healthStatus = healthStatus;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Integer getQuantity () {
						return quantity == null ? Integer.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Integer quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: volume
	 */

	public java.lang.Double getVolume () {
						return volume == null ? Double.valueOf(0) : volume;
		}



	/**
	 * Set the value related to the column: volume
	 * @param volume the volume value
	 */
			public void setVolume (java.lang.Double volume) {
			this.volume = volume;
	}



	/**
	 * Return the value associated with the column: unit
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: unit
	 * @param unit the unit value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: blood_bag_no
	 */

	public java.lang.String getBloodBagNo () {
			return bloodBagNo;
	}



	/**
	 * Set the value related to the column: blood_bag_no
	 * @param bloodBagNo the blood_bag_no value
	 */
			public void setBloodBagNo (java.lang.String bloodBagNo) {
			this.bloodBagNo = bloodBagNo;
	}



	/**
	 * Return the value associated with the column: status
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: status
	 * @param status the status value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: purchase_order_id
	 */

	public java.lang.String getPurchaseOrderId () {
			return purchaseOrderId;
	}



	/**
	 * Set the value related to the column: purchase_order_id
	 * @param purchaseOrderId the purchase_order_id value
	 */
			public void setPurchaseOrderId (java.lang.String purchaseOrderId) {
			this.purchaseOrderId = purchaseOrderId;
	}



	/**
	 * Return the value associated with the column: vendor_id
	 */

	public java.lang.String getVendorId () {
			return vendorId;
	}



	/**
	 * Set the value related to the column: vendor_id
	 * @param vendorId the vendor_id value
	 */
			public void setVendorId (java.lang.String vendorId) {
			this.vendorId = vendorId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.BloodDonationHistory)) return false;
		else {
			com.floreantpos.model.BloodDonationHistory bloodDonationHistory = (com.floreantpos.model.BloodDonationHistory) obj;
			if (null == this.getId() || null == bloodDonationHistory.getId()) return this == obj;
			else return (this.getId().equals(bloodDonationHistory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}