package com.floreantpos.model.ext;

import com.floreantpos.model.TicketItem;
import com.floreantpos.model.UnitType;

public class InvMapKey {
	/**
	 * 
	 */
	TicketItem ticketItem;
	String menuItemId;
	String unitId;
	String unitType;
	boolean itemReturned;

	public InvMapKey(String menuItemId, String unitId) {
		this(menuItemId, unitId, UnitType.UNIT.name());
	}

	public InvMapKey(String menuItemId, String unitId, String unitType) {
		super();
		this.menuItemId = menuItemId;
		this.unitId = unitId;
		this.unitType = unitType;
	}

	public InvMapKey(TicketItem ticketItem) {
		super();
		this.ticketItem = ticketItem;
		this.menuItemId = ticketItem.getMenuItemId();
		this.unitId = ticketItem.getUnitName();
		this.unitType =  ticketItem.getUnitType();
	}

	public String getMenuItemId() {
		return menuItemId;
	}

	public String getUnitId() {
		return unitId;
	}

	public String getUnitType() {
		return unitType;
	}

	public void setUnitType(String unitType) {
		this.unitType = unitType;
	}

	public TicketItem getTicketItem() {
		return ticketItem;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((menuItemId == null) ? 0 : menuItemId.hashCode());
		result = prime * result + ((unitId == null) ? 0 : unitId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		InvMapKey other = (InvMapKey) obj;
		if (menuItemId == null) {
			if (other.menuItemId != null)
				return false;
		}
		else if (!menuItemId.equals(other.menuItemId))
			return false;
		if (unitId == null) {
			if (other.unitId != null)
				return false;
		}
		else if (!unitId.equals(other.unitId))
			return false;
		return true;
	}

	public boolean isItemReturned() {
		return itemReturned;
	}

	public void setItemReturned(boolean itemReturned) {
		this.itemReturned = itemReturned;
	}

}