package com.orocube.siiopa.accounting.client.service;

import java.util.Date;
import java.util.List;

import com.floreantpos.model.dao.LedgerEntryDAO;
import com.floreantpos.report.model.BalanceSheetLedgerEntryModel;

public class IncomeStatementService {

	private Date startDate;
	private Date endDate;

	private double totalSales;
	private double totalDirectCost;
	private List<BalanceSheetLedgerEntryModel> expenseList;
	private double totalExpenseAamount;
	private double grossProfit;
	private double totalOparatingProfit;

	public IncomeStatementService(Date startDate, Date endDate) {
		this.startDate = startDate;
		this.endDate = endDate;

		searchData();

	}

	private void searchData() {
		totalSales = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("revenue", startDate, endDate); //$NON-NLS-1$
		totalDirectCost = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("direct_costs", startDate, endDate); //$NON-NLS-1$
		expenseList = LedgerEntryDAO.getInstance().getExpenseLedgerEntries(startDate, endDate);
		//by default sales will be negative
		totalExpenseAamount = expenseList.stream().mapToDouble(e -> e.getAmount()).sum();
		grossProfit = totalSales + totalDirectCost;
		totalOparatingProfit = grossProfit + totalExpenseAamount;
	}

	public double getTotalSales() {
		return totalSales;
	}

	public double getTotalDirectCost() {
		return totalDirectCost;
	}

	public List<BalanceSheetLedgerEntryModel> getExpenseList() {
		return expenseList;
	}

	public double getTotalExpenseAamount() {
		return totalExpenseAamount;
	}

	public double getGrossProfit() {
		return grossProfit;
	}

	public double getTotalOparatingProfit() {
		return totalOparatingProfit;
	}

}
