package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_GLOBAL_PRESCRIPTION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_GLOBAL_PRESCRIPTION"
 */

public abstract class BaseGlobalPrescription  implements Serializable {

	public static String REF = "GlobalPrescription"; //$NON-NLS-1$
	public static String PROP_DOCTOR_NAME = "doctorName"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_PHONE = "doctorPhone"; //$NON-NLS-1$
	public static String PROP_PRESCRIPTION_ID = "prescriptionId"; //$NON-NLS-1$
	public static String PROP_PATIENT_NAME = "patientName"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_PRESCRIPTION_JSON = "prescriptionJson"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PATIENT_PHONE = "patientPhone"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseGlobalPrescription () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseGlobalPrescription (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String outletId;
				private java.lang.String storeId;
				private java.lang.String doctorId;
				private java.lang.String doctorName;
				private java.lang.String doctorPhone;
				private java.lang.String patientId;
				private java.lang.String patientName;
				private java.lang.String patientPhone;
				private java.lang.String prescriptionId;
				private java.lang.String prescriptionJson;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: doctor_id
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: doctor_id
	 * @param doctorId the doctor_id value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: doctor_name
	 */

	public java.lang.String getDoctorName () {
			return doctorName;
	}



	/**
	 * Set the value related to the column: doctor_name
	 * @param doctorName the doctor_name value
	 */
			public void setDoctorName (java.lang.String doctorName) {
			this.doctorName = doctorName;
	}



	/**
	 * Return the value associated with the column: doctor_phone
	 */

	public java.lang.String getDoctorPhone () {
			return doctorPhone;
	}



	/**
	 * Set the value related to the column: doctor_phone
	 * @param doctorPhone the doctor_phone value
	 */
			public void setDoctorPhone (java.lang.String doctorPhone) {
			this.doctorPhone = doctorPhone;
	}



	/**
	 * Return the value associated with the column: patient_id
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: patient_id
	 * @param patientId the patient_id value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: patient_name
	 */

	public java.lang.String getPatientName () {
			return patientName;
	}



	/**
	 * Set the value related to the column: patient_name
	 * @param patientName the patient_name value
	 */
			public void setPatientName (java.lang.String patientName) {
			this.patientName = patientName;
	}



	/**
	 * Return the value associated with the column: patient_phone
	 */

	public java.lang.String getPatientPhone () {
			return patientPhone;
	}



	/**
	 * Set the value related to the column: patient_phone
	 * @param patientPhone the patient_phone value
	 */
			public void setPatientPhone (java.lang.String patientPhone) {
			this.patientPhone = patientPhone;
	}



	/**
	 * Return the value associated with the column: prescription_id
	 */

	public java.lang.String getPrescriptionId () {
			return prescriptionId;
	}



	/**
	 * Set the value related to the column: prescription_id
	 * @param prescriptionId the prescription_id value
	 */
			public void setPrescriptionId (java.lang.String prescriptionId) {
			this.prescriptionId = prescriptionId;
	}



	/**
	 * Return the value associated with the column: prescription_json
	 */

	public java.lang.String getPrescriptionJson () {
			return prescriptionJson;
	}



	/**
	 * Set the value related to the column: prescription_json
	 * @param prescriptionJson the prescription_json value
	 */
			public void setPrescriptionJson (java.lang.String prescriptionJson) {
			this.prescriptionJson = prescriptionJson;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.GlobalPrescription)) return false;
		else {
			com.floreantpos.model.GlobalPrescription globalPrescription = (com.floreantpos.model.GlobalPrescription) obj;
			if (null == this.getId() || null == globalPrescription.getId()) return this == obj;
			else return (this.getId().equals(globalPrescription.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}