package com.floreantpos.services.report;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.AdvanceRefundTransaction;
import com.floreantpos.model.AdvanceTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PropertyContainer2;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class CashDrawerDetailReport implements PropertyContainer2 {
	public final static String TRANS_TIME = "transTime"; //$NON-NLS-1$
	public final static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public final static String INVOICE_ID = "invoiceId"; //$NON-NLS-1$
	public final static String RECEPIENT_ID = "recepientId"; //$NON-NLS-1$
	public final static String TRANSACTION_AMOUNT = "transactionAmount"; //$NON-NLS-1$
	public final static String PAYMENT_TYPE = "paymentType"; //$NON-NLS-1$
	public static final String USER_ID = "userId"; //$NON-NLS-1$
	public static final String PROPERTIES = "properties"; //$NON-NLS-1$

	private Date transTime;
	private String transTimeDisplay;
	private String properties;
	private Ticket ticket;
	private String invoiceId;
	private String recepientId;
	private String userId;
	private Double transactionAmount;
	private String recepientName;
	private String customerName;
	private String depositFromName;
	private String invoiceDate;
	private String ticketId;
	private String paymentType;
	private transient JsonObject propertiesContainer;
	private String voidedByUserName;

	public CashDrawerDetailReport() {
	}

	public CashDrawerDetailReport(PosTransaction transaction, Date orderDate) {
		setTransactionAmount(transaction.getAmount());
		transTime = transaction.getTransactionTime();
		setTransTimeDisplay(DateUtil.formatReportDateWithBrowserTimeOffset(transTime));
		setCustomerName(transaction.getRecepientCustomerName());
		setPaymentType(transaction.getPaymentTypeDisplayString());

		if (orderDate == null) {
			ticket = transaction.getTicket();
			if (ticket != null) {
				invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(ticket.getCreateDate());
			}
		}
		else {
			invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(orderDate);
		}

		if (StringUtils.isNotBlank(transaction.getAdvanceTransactionTicketId())) {
			invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(transaction.getTransactionTime());
		}

		String transTicketIds = transaction.getTransTicketIdsDisplay();
		if (!StringUtils.isNotBlank(transTicketIds) || !transTicketIds.contains(",")) {
			ticketId = transTicketIds;
		}

		if (StringUtils.isNotBlank(transaction.getAdvanceTransactionTicketId())) {
			ticketId = transaction.getAdvanceTransactionTicketId() + " (Advance deposit)";
		}
		else if (StringUtils.isBlank(transaction.getAdvanceTransactionTicketId()) && transaction instanceof AdvanceTransaction) {
			ticketId = "Advance";
		}
		else if (transaction instanceof AdvanceRefundTransaction) {
			ticketId = "Advance refund";
		}
		else {
			ticketId = transaction.getTicketId();
		}

	}

	public String getTransTimeDisplay() {
		return transTimeDisplay;
	}

	public void setTransTimeDisplay(String transTimeDisplay) {
		this.transTimeDisplay = transTimeDisplay;
	}

	public String getProperties() {
		return properties;
	}

	public void setProperties(String properties) {
		this.properties = properties;
	}

	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getInvoiceId() {
		return invoiceId;
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
		if (ticket != null) {
			this.ticketId = ticket.getId();
		}
	}

	public String getTicketId() {
		return ticketId;
	}

	public String getRecepientId() {
		return recepientId;
	}

	public void setRecepientName(String recepientIName) {
		this.recepientName = recepientIName;
	}

	public String getRecepientName() {
		return recepientName;
	}

	public void initCustomerName() {
		String recepientId = getRecepientId();
		if (StringUtils.isBlank(recepientId)) {
			setCustomerName(""); //$NON-NLS-1$
		}
		else {
			Customer customer = (Customer) DataProvider.get().getObjectOf(Customer.class, recepientId);
			if (customer == null) {
				setCustomerName(""); //$NON-NLS-1$
			}
			else {
				setCustomerName(customer.getName());
			}
		}
	}

	public void initInvoiceDate() {
		if (ticket != null) {
			invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(ticket.getCreateDate());
		}
		if (transTime != null) {
			setTransTimeDisplay(DateUtil.formatReportDateWithBrowserTimeOffset(transTime));
		}

	}

	public void initRecepientName() {
		String recepientId = getRecepientId();
		if (StringUtils.isBlank(recepientId)) {
			setRecepientName(""); //$NON-NLS-1$
		}
		else {
			PayoutRecepient customer = (PayoutRecepient) DataProvider.get().getObjectOf(PayoutRecepient.class, recepientId);
			if (customer == null) {
				setRecepientName(""); //$NON-NLS-1$
			}
			else {
				setRecepientName(customer.getName());
			}
		}
		initInvoiceDate();
	}

	public void initDepositFromName() {
		String properties = getProperties();
		if (StringUtils.isBlank(properties)) {
			setDepositFromName(""); //$NON-NLS-1$
		}
		else {
			setDepositFromName(getProperty(BalanceUpdateTransaction.DEPOSIT_FROM_NAME));
		}
		initInvoiceDate();
	}

	public void setRecepientId(String recepientId) {
		this.recepientId = recepientId;
	}

	public Double getTransactionAmount() {
		return transactionAmount;
	}

	public void setTransactionAmount(Double ticketAmount) {
		this.transactionAmount = ticketAmount;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getDepositFromName() {
		return depositFromName;
	}

	public void setDepositFromName(String depositFromName) {
		this.depositFromName = depositFromName;
	}

	public String getInvoiceDate() {
		return invoiceDate;
	}

	public Date getTransTime() {
		return transTime;
	}

	public String getPaymentType() {
		return paymentType;

	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getVoidedByUserName() {
		return voidedByUserName;
	}

	public void initVoidedByUser() {
		voidedByUserName = ""; //$NON-NLS-1$
		String voidedByUserId = getProperty("voidedByUser"); //$NON-NLS-1$
		if (StringUtils.isBlank(voidedByUserId)) {
			voidedByUserId = getUserId();
		}

		User user = (User) DataProvider.get().getUserById(voidedByUserId, DataProvider.get().getOutletId());
		if (user != null) {
			voidedByUserName = user.getFullName();
		}
		initInvoiceDate();
	}

}
