/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.SerializationUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.UserTypeDAO;

public class UpdateDBTo376 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo376(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");

		List<Outlet> outlets = OutletDAO.getInstance().findAll();
		if (outlets == null || outlets.isEmpty()) {
			return;
		}
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();

			String sourceOutletId = outlets.get(0).getId();
			fixBrokenRelation(session, sourceOutletId);

			if (outlets.size() > 1) {

				List<UserType> userTypes = UserTypeDAO.getInstance().findUserTypeBy(sourceOutletId, session);
				if (userTypes.isEmpty()) {
					return;
				}

				for (Outlet outlet : outlets) {
					if (outlet.getId().equals(sourceOutletId)) {
						continue;
					}

					updateUserType(session, userTypes, sourceOutletId, outlet.getId());
				}
			}
			transaction.commit();
		}

	}

	public void fixBrokenRelation(Session session, String outletId) {
		String userTypeQuery = "update %s.user_type set outlet_id = '%s' where outlet_id is null";
		PosLog.info(getClass(), userTypeQuery);
		Query selectQuery = session.createSQLQuery(String.format(userTypeQuery, schemaName, outletId));
		int updateUserType = selectQuery.executeUpdate();
		PosLog.info(getClass(), "updated " + updateUserType + " user_type"); //$NON-NLS-1$ //$NON-NLS-2$

	}

	public void updateUserType(Session session, List<UserType> sourceUserTypes, String sourceOutletId, String outletId) {

		for (UserType userType : sourceUserTypes) {
			if (userType == null) {
				continue;
			}

			String oldUserTypeId = userType.getId();
			PosLog.debug(getClass(), "oldUserTypeId: " + oldUserTypeId + ", outletId: " + outletId);
			if (UserTypeDAO.getInstance().get(oldUserTypeId + "_" + outletId, session) != null) {
				break;
			}

			Set<UserPermission> userPermissions = userType.getPermissions();
			if (userPermissions == null) {
				userPermissions = new HashSet<>();
			}
			userType = (UserType) SerializationUtils.clone(userType);
			userType.setId(oldUserTypeId + "_" + outletId);
			userType.setOutletId(outletId);
			userType.setVersion(0);
			userType.setLastSyncTime(null);
			userType.setLastUpdateTime(null);
			userType.setPermissions(new HashSet<UserPermission>(userPermissions));

			session.save(userType);
		}
	}

}