/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import com.floreantpos.report.model.SessionSummaryReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

/**
 * Created by IntelliJ IDEA.
 * User: mshahriar
 * Date: Feb 28, 2007
 * Time: 12:41:32 AM
 * To change this template use File | Settings | File Templates.
 */
public class SessionSummaryReportModel extends ListTableModel {
	private String[] columnNames = { "period", "sessionID", "openingBalance", "deposits", "outage", "cash", "tips", "onAcct", "otherPmt", "payInOut", "voids", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$ //$NON-NLS-11$
			"totalGuest", "avgChk", "refund", "outletId" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

	public SessionSummaryReportModel() {
		setColumnNames(columnNames);
	}

	public SessionSummaryReportModel(List rows) {
		setColumnNames(columnNames);
		setRows(rows);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		SessionSummaryReportData reportData = (SessionSummaryReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getPeriod();

			case 1:
				return reportData.getSessionID();

			case 2:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getOpeningBalance());
				
			case 3:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getDeposit());

			case 4:
				return reportData.getOverOutage();

			case 5:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getCash());

			case 6:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getTips());

			case 7:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getOnAccount());

			case 8:
				return reportData.getOtherPayment();

			case 9:
				return reportData.getPayInOut();

			case 10:
				return reportData.getVoids();

			case 11:
				return NumberUtil.getIntegerFormat(reportData.getTotalGuest());

			case 12:
				return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getAvgChk());

			case 13:
				return reportData.getRefund();

			case 14:
				return reportData.getOutletId() == null ? "" : reportData.getOutletId(); //$NON-NLS-1$
		}
		return null;
	}
}
