package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum ChallanStatus {
	CREATED(0), PRINTED(1), SHIPPED(2), COMPLETED(3);

	private final int statusCode;

	ChallanStatus(int statusCode) {
		this.statusCode = statusCode;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public static ChallanStatus fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		ChallanStatus[] values = values();
		for (ChallanStatus challanStatus : values) {
			if (name.equals(challanStatus.name())) {
				return challanStatus;
			}
		}

		return null;
	}
}
