/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.swing.ListTableModel;

public class ProjectReportDataModel extends ListTableModel {

	public ProjectReportDataModel() {
		setColumnNames(new String[] { "date", "type", "projectname", "description", "amount" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction data = (PosTransaction) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return data.getDateDisplayString();

			case 1:
				return data.getClassTypeDislay();

			case 2:
				return data.getProjectNameDisplay();

			case 3:
				return data.getProjectDescription();

			case 4:
				return data.getAmountDisplay();

		}
		return null;
	}

}
