package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;

public class StockCountItemDAO extends BaseStockCountItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public StockCountItemDAO() {
	}

	public List<StockCountItem> getStockCountItemByInvLocation(InventoryLocation inventoryLocation, Session session) {
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(StockCountItem.PROP_INVENTORY_LOCATION, inventoryLocation));
		criteria.createAlias(StockCountItem.PROP_STOCK_COUNT, "stockCount"); //$NON-NLS-1$
		criteria.add(Restrictions.isNull("stockCount." + StockCount.PROP_VERIFIED_BY)); //$NON-NLS-1$
		criteria.setProjection(Projections.alias(Projections.property(StockCountItem.PROP_NAME), StockCountItem.PROP_NAME));
		return criteria.setResultTransformer(Transformers.aliasToBean(getReferenceClass())).list();
	}

}