package com.floreantpos.model;

import java.util.List;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseRequisition;
import com.floreantpos.model.ext.ResetBeforeRefresh;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Requisition extends BaseRequisition implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	@ResetBeforeRefresh
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Requisition() {
	}

	/**
	 * Constructor for primary key
	 */
	public Requisition(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public static final int ORDER_PENDING = 0;
	public static final int ORDER_APPROVED = 1;
	public static final int ORDER_DONE = 2;
	public static final int ORDER_DECLINED = 3;
	public static final int ORDER_PO_CREATED = 4;

	public static final String[] ORDER_STATUS = { "Pending", "Approved", "Done", "Declined", "PO Created" };

	@XmlTransient
	@JsonIgnore
	public String getOrderStatusDisplay() {
		return ORDER_STATUS[getOrderStatus()];
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	@JsonIgnore
	public String getCreatedDateAsString() {
		if (super.getCreateDate() == null) {
			return ""; //$NON-NLS-1$
		}
		return DateUtil.formatAsShortDate(super.getCreateDate());
	}

	@XmlTransient
	@JsonIgnore
	public String getApprovedDateAsString() {
		if (super.getApprovedDate() == null) {
			return ""; //$NON-NLS-1$
		}
		return DateUtil.formatAsShortDate(super.getApprovedDate());
	}

	@XmlTransient
	@JsonIgnore
	public String getDoneDateAsString() {
		if (super.getDoneDate() == null) {
			return ""; //$NON-NLS-1$
		}
		return DateUtil.formatAsShortDate(super.getDoneDate());
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public void putItems(List<RequisitionItemModel> items) {
		if (items == null) {
			return;
		}
		Gson gson = GsonUtil.createGson();
		String json = gson.toJson(items);
		setItemsJson(json);
	}

	public List<RequisitionItemModel> getItems() {
		return GsonUtil.convertJSONToList(getItemsJson(), RequisitionItemModel.class);
	}

	public User getCreatedBy() {
		return DataProvider.get().getUserById(getCreatedByUserId(), getOutletId());
	}

	public User getApprovedBy() {
		return DataProvider.get().getUserById(getApprovedByUserId(), getOutletId());
	}

	public double getPaidAmount() {
		return getDoubleProperty("paid.amount");
	}

	public void putPaidAmount(double amount) {
		addProperty("paid.amount", String.valueOf(amount));
	}

	public User getRequisitionToUser() {
		return DataProvider.get().getUserById(getRequisitionToUserId(), getOutletId());
	}

	public String getRequisitionToUserId() {
		return getProperty("requisition_to", StringUtils.EMPTY);
	}

	public void putRequisitionToUserId(User user) {
		addProperty("requisition_to", user == null ? null : user.getId());
	}

	public String getPaidToUserId() {
		return getProperty("paid_to", StringUtils.EMPTY);
	}

	public void putPaidToUserId(User user) {
		addProperty("paid_to", user == null ? null : user.getId());
	}

	public String getPurchaseOrderId() {
		return getProperty("purchase_order.id");
	}

	public void putPurchaseOrderId(String purchaseOrderId) {
		addProperty("purchase_order.id", purchaseOrderId);
	}

	public String getPurchaseOrderShortId() {
		return getProperty("purchase_order.short.id");
	}

	public void putPurchaseOrderShortId(String purchaseOrderShortId) {
		addProperty("purchase_order.short.id", purchaseOrderShortId);
	}
}