/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import javax.swing.table.AbstractTableModel;

public class PurchaseOrderItemReportModel extends AbstractTableModel {

	private String[] columnNames = { "date", "name", "cost", "qty", "unit", "netTotal", "group" };//$NON-NLS-1$
	private List<POIReportItem> items;

	private double gndTotalGrossSales;
	private double gndTotalDiscount;
	private double gndTotalRFCommission;
	private double gndTotalLabDoctorFee;
	private double gndTotalReturn;
	private double gndTotalNetSales;
	private double gndTotalServCharge;
	private double gndTotalTax;
	private double gndTotalTotal;
	private double gndTotalCost;
	private double gndTotalProfit;

	public PurchaseOrderItemReportModel() {
		super();
	}

	public int getRowCount() {
		if (items == null) {
			return 0;
		}

		return items.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		POIReportItem item = items.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return item.getCreatedDateAsString();

			case 1:
				return item.getName();

			case 2:
				return item.getCost();

			case 3:
				return item.getQuantity();

			case 4:
				return item.getUnit();

			case 5:
				return item.getNetTotal();

			case 6:
				return item.getGroupName();
		}

		return null;
	}

	public List<POIReportItem> getItems() {
		return items;
	}

	public void setItems(List<POIReportItem> items) {
		this.items = items;
	}

	public double getGndTotalGrossSales() {
		return gndTotalGrossSales;
	}

	public void setGndTotalGrossSales(double gndTotalGrossSales) {
		this.gndTotalGrossSales = gndTotalGrossSales;
	}

	public double getGndTotalDiscount() {
		return gndTotalDiscount;
	}

	public void setGndTotalDiscount(double gndTotalDiscount) {
		this.gndTotalDiscount = gndTotalDiscount;
	}

	public double getGndTotalRFCommission() {
		return gndTotalRFCommission;
	}

	public void setGndTotalRFCommission(double gndTotalRFCommission) {
		this.gndTotalRFCommission = gndTotalRFCommission;
	}

	public double getGndTotalLabDoctorFee() {
		return gndTotalLabDoctorFee;
	}

	public void setGndTotalLabDoctorFee(double gndTotalLabDoctorFee) {
		this.gndTotalLabDoctorFee = gndTotalLabDoctorFee;
	}

	public double getGndTotalReturn() {
		return gndTotalReturn;
	}

	public void setGndTotalReturn(double gndTotalReturn) {
		this.gndTotalReturn = gndTotalReturn;
	}

	public double getGndTotalNetSales() {
		return gndTotalNetSales;
	}

	public void setGndTotalNetSales(double gndTotalNetSales) {
		this.gndTotalNetSales = gndTotalNetSales;
	}

	public double getGndTotalServCharge() {
		return gndTotalServCharge;
	}

	public void setGndTotalServCharge(double gndTotalServCharge) {
		this.gndTotalServCharge = gndTotalServCharge;
	}

	public double getGndTotalTax() {
		return gndTotalTax;
	}

	public void setGndTotalTax(double gndTotalTax) {
		this.gndTotalTax = gndTotalTax;
	}

	public double getGndTotalTotal() {
		return gndTotalTotal;
	}

	public void setGndTotalTotal(double gndTotalTotal) {
		this.gndTotalTotal = gndTotalTotal;
	}

	public double getGndTotalCost() {
		return gndTotalCost;
	}

	public void setGndTotalCost(double gndTotalCost) {
		this.gndTotalCost = gndTotalCost;
	}

	public double getGndTotalProfit() {
		return gndTotalProfit;
	}

	public void setGndTotalProfit(double gndTotalProfit) {
		this.gndTotalProfit = gndTotalProfit;
	}

	public void calculateGrandTotal() {
		//if (items == null) {
		//	return;
		//}
		//double grossSale = 0;
		//double discount = 0;
		//double rfCommission = 0;
		//double labDoctorFee = 0;
		//double returnAmount = 0;
		//double netSales = 0;
		//double servCharge = 0;
		//double totaltax = 0;
		//double grossTotal = 0;
		//double totalCost = 0;
		//double totalProfit = 0;
		//
		//for (PurchaseOrderItem item : items) {
		//	grossSale += item.getGrossSale();
		//	discount += item.getDiscount();
		//	rfCommission += item.getAgentFeeAmount();
		//	labDoctorFee += item.getLabDoctorFeeAmount();
		//	returnAmount += item.getReturnAmount();
		//	netSales += item.getNetTotal();
		//	servCharge += item.getServiceCharge();
		//	totaltax += item.getTaxTotal();
		//	grossTotal += item.getGrossTotal();
		//	totalCost += item.getCost();
		//	totalProfit += item.getGrossTotal() - item.getCost();
		//}
		//
		//setGndTotalGrossSales(grossSale);
		//setGndTotalDiscount(discount);
		//setGndTotalRFCommission(rfCommission);
		//setGndTotalLabDoctorFee(labDoctorFee);
		//setGndTotalReturn(returnAmount);
		//setGndTotalNetSales(netSales);
		//setGndTotalServCharge(servCharge);
		//setGndTotalTax(totaltax);
		//setGndTotalTotal(grossTotal);
		//setGndTotalCost(totalCost);
		//setGndTotalProfit(totalProfit);
	}

}
