package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the CRON_JOB table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CRON_JOB"
 */

public abstract class BaseCronJob  implements Comparable, Serializable {

	public static String REF = "CronJob"; //$NON-NLS-1$
	public static String PROP_EXECUTION_TIME = "executionTime"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_JOB_NAME = "jobName"; //$NON-NLS-1$
	public static String PROP_FREQUENCY = "frequency"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_JOB_ID = "jobId"; //$NON-NLS-1$


	// constructors
	public BaseCronJob () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCronJob (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String jobId;
				private java.lang.String jobName;
				private java.lang.String frequency;
				private java.lang.String executionTime;
				private java.lang.String properties;
				private java.lang.Boolean active;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: JOB_ID
	 */

	public java.lang.String getJobId () {
			return jobId;
	}



	/**
	 * Set the value related to the column: JOB_ID
	 * @param jobId the JOB_ID value
	 */
			public void setJobId (java.lang.String jobId) {
			this.jobId = jobId;
	}



	/**
	 * Return the value associated with the column: JOB_NAME
	 */

	public java.lang.String getJobName () {
			return jobName;
	}



	/**
	 * Set the value related to the column: JOB_NAME
	 * @param jobName the JOB_NAME value
	 */
			public void setJobName (java.lang.String jobName) {
			this.jobName = jobName;
	}



	/**
	 * Return the value associated with the column: FREQUENCY
	 */

	public java.lang.String getFrequency () {
			return frequency;
	}



	/**
	 * Set the value related to the column: FREQUENCY
	 * @param frequency the FREQUENCY value
	 */
			public void setFrequency (java.lang.String frequency) {
			this.frequency = frequency;
	}



	/**
	 * Return the value associated with the column: JOB_TIME
	 */

	public java.lang.String getExecutionTime () {
			return executionTime;
	}



	/**
	 * Set the value related to the column: JOB_TIME
	 * @param executionTime the JOB_TIME value
	 */
			public void setExecutionTime (java.lang.String executionTime) {
			this.executionTime = executionTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */

	public java.lang.Boolean isActive () {
					return active == null ? Boolean.FALSE : active;
		}

	public java.lang.Boolean getActive () {
				return active == null ? Boolean.FALSE : active;
			}


	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.CronJob)) return false;
		else {
			com.floreantpos.model.CronJob cronJob = (com.floreantpos.model.CronJob) obj;
			if (null == this.getId() || null == cronJob.getId()) return this == obj;
			else return (this.getId().equals(cronJob.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}