package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum BloodGroupType {
	//@formatter:off
		A_POSITIVE("A+"),
		A_NEGATIVE("A-"),
		B_POSITIVE("B+"),
		B_NEGATIVE("B-"),
		AB_POSITIVE("AB+"),
		AB_NEGATIVE("AB-"),
		O_POSITIVE("O+"),
		O_NEGATIVE("O-"),
		;
	//@formatter:on

	private String displayString;

	BloodGroupType(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public static BloodGroupType fromDisplayString(String displayString) {
		if (StringUtils.isBlank(displayString)) {
			return null;
		}
		BloodGroupType[] bloodGroupTypes = values();
		for (BloodGroupType bloodGroupType : bloodGroupTypes) {
			if (bloodGroupType.getDisplayString().equals(displayString)) {
				return bloodGroupType;
			}
		}
		return null;
	}

	public static BloodGroupType fromNameString(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		BloodGroupType[] bloodGroupTypes = values();
		for (BloodGroupType type : bloodGroupTypes) {
			if (type.name().equals(name)) {
				return type;
			}
		}
		return null;
	}

}
