/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlTransient;

import org.json.JSONObject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTicketItemCookingInstruction;
import com.floreantpos.model.ext.KitchenStatus;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "saved", "kitchenStatusValue", "parentItem" })
public class TicketItemCookingInstruction extends BaseTicketItemCookingInstruction implements ITicketItem {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TicketItemCookingInstruction() {
	}

	/*[CONSTRUCTOR MARKER END]*/
	private TicketItem parentItem;

	private int tableRowNum;
	private int index = 1;

	public int getTableRowNum() {
		return tableRowNum;
	}

	public void setTableRowNum(int tableRowNum) {
		this.tableRowNum = tableRowNum;
	}

	public boolean canAddCookingInstruction() {
		return false;
	}

	@Override
	public String toString() {
		return getDescription();
	}

	@Override
	public String getNameDisplay() {
		return "   * " + getDescription(); //$NON-NLS-1$
	}

	@Override
	public String getUnitPriceDisplay() {
		return null;
	}

	@Override
	public String getItemQuantityDisplay() {
		return null;
	}

	@Override
	public String getTaxAmountWithoutModifiersDisplay() {
		return null;
	}

	@Override
	public String getItemCode() {
		return ""; //$NON-NLS-1$
	}

	@Override
	public boolean canAddDiscount() {
		return false;
	}

	@Override
	public boolean canVoid() {
		return false;
	}

	@Override
	public boolean canAddAdOn() {
		return false;
	}

	@Override
	public void setDiscountAmount(Double amount) {
	}

	@Override
	public Double getDiscountAmount() {
		return null;
	}

	@Override
	public Double getSubtotalAmount() {
		return null;
	}

	@Override
	public String getSubTotalAmountDisplay() {
		return null;
	}

	private String ticketItemId;

	public String getTicketItemId() {
		return ticketItemId;
	}

	public void setTicketItemId(String ticketItemId) {
		this.ticketItemId = ticketItemId;
	}

	public void setPrintedToKitchen(Boolean printedToKitchen) {
		super.setPrintedToKitchen(printedToKitchen);
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	@XmlTransient
	public KitchenStatus getKitchenStatusValue() {
		return KitchenStatus.fromString(super.getKitchenStatus());
	}

	public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
		super.setKitchenStatus(kitchenStatus == null ? null : kitchenStatus.name());
	}

	public void setParentItem(TicketItem parentItem) {
		this.parentItem = parentItem;
		
		if (parentItem != null) {
			setTicketItemId(parentItem.getId());
		}
		else {
			setTicketItemId(null);
		}
	}
	
	@XmlTransient
	public TicketItem getParentItem() {
		return parentItem;
	}

	public JSONObject toJson() {
		JSONObject jsonObject = new JSONObject();
		jsonObject.put(PROP_DESCRIPTION, getDescription());
		jsonObject.put(PROP_PRINTED_TO_KITCHEN, isPrintedToKitchen());
		jsonObject.put(PROP_SAVED, isSaved());
		jsonObject.put(PROP_KITCHEN_STATUS, getKitchenStatus());
		jsonObject.put("ticketItemId", getTicketItemId());
		return jsonObject;
	}
}