package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseReseller;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class Reseller extends BaseReseller {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Reseller () {
    }

	/**
	 * Constructor for primary key
	 */
	public Reseller (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		String fName = getName();
		if (fName == null) {
			fName = getEmail();
		}
		return fName;
	}

	public String getName() {
		String name = super.getFirstName(); //$NON-NLS-1$
		if (StringUtils.isNotEmpty(super.getLastName())) {
			name += " " + super.getLastName(); //$NON-NLS-1$
		}
		return name;
	}

	public void setEncryptedSecretCode(String secretCode) {
		try {
			setSecretCode(AESencrp.encrypt(secretCode));
		} catch (Exception e) {
			setSecretCode(secretCode);
		}
	}

	public String getUnencryptedSecretCode() {
		String secretKey = getSecretCode();
		if (StringUtils.isNotEmpty(secretKey)) {
			try {
				secretKey = AESencrp.decrypt(secretKey);
			} catch (Exception e) {
			}
		}
		return secretKey;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		if (StringUtils.isNotEmpty(properties)) {
			propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		}
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		if (StringUtils.isNotEmpty(value)) {
			propertiesContainer.addProperty(key, value);
		}
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}

}