package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.PayoutSubReason;
import com.floreantpos.swing.PaginationSupport;

public class PayoutSubReasonDAO extends BasePayoutSubReasonDAO {

	public PayoutSubReasonDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public boolean subReasonExists(String name, String id) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			if (StringUtils.isNotEmpty(id)) {
				criteria.add(Restrictions.ne(PayoutSubReason.PROP_ID, id));
			}
			criteria.add(Restrictions.eq(PayoutSubReason.PROP_REASON, name).ignoreCase());
			addDeletedFilter(criteria);
			Number rowCount = (Number) criteria.uniqueResult();
			return rowCount != null && rowCount.intValue() > 0;
		} finally {
			closeSession(session);
		}
	}

	@Override
	protected void delete(Object obj, Session session) {
		PayoutSubReason bean = (PayoutSubReason) obj;
		if (bean == null) {
			throw new PosException(Messages.getString("PayoutReasonDAO.0")); //$NON-NLS-1$
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<PayoutSubReason> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	public void findBySubReason(String payoutSubReason, PaginationSupport tableModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(PayoutSubReason.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(payoutSubReason)) {
				criteria.add(Restrictions.ilike(PayoutSubReason.PROP_REASON, payoutSubReason, MatchMode.ANYWHERE));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(PayoutSubReason.PROP_REASON).ignoreCase());
			tableModel.setRows(criteria.list());
		}
	}

}