/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.config;

import java.util.List;

import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;

public class CardConfig {
	private static final String CARD_READER = "CARD_READER"; //$NON-NLS-1$

	public static void setDefaultCardReader(CardReader card) {
		Terminal terminal = DataProvider.get().getCurrentTerminal();
		terminal.addProperty(CARD_READER, card.name());
	}

	public static CardReader getDefaultCardReader() {
		Terminal terminal = DataProvider.get().getCurrentTerminal();
		String string = terminal.getProperty(CARD_READER, "SWIPE");
		CardReader cardReader = CardReader.fromString(string);
		return cardReader != null ? cardReader : CardReader.SWIPE;
	}

	public static PaymentGatewayPlugin getPaymentGateway() {
		String gatewayId = DataProvider.get().getCurrentTerminal().getActivePaymentMethodId();
		if (gatewayId == null) {
			return null;
		}
		return getPaymentGateway(gatewayId);
	}

	public static PaymentGatewayPlugin getPaymentGateway(String gatewayId) {

		List<FloreantPlugin> plugins = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
		for (FloreantPlugin plugin : plugins) {
			if (gatewayId.equals(plugin.getId())) {
				return (PaymentGatewayPlugin) plugin;
			}
		}
		// should not reach here
		return null;
	}

	public static PaymentGatewayPlugin getPaymentGatewayByName(String gatewayName) {
		List<FloreantPlugin> plugins = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);

		for (FloreantPlugin plugin : plugins) {
			PaymentGatewayPlugin gatewayPlugin = (PaymentGatewayPlugin) plugin;
			if (gatewayName.equals(gatewayPlugin.getProductName())) {
				return (PaymentGatewayPlugin) plugin;
			}
		}

		// should not reach here
		return null;
	}
}
