/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;

import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class UpdateDBTo325 {

	private String dbConnectString;
	private String user;
	private String password;
	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo325(String dbConnectString, String user, String password, SessionFactory sessionFactory, String schemaName) {
		this.dbConnectString = dbConnectString;
		this.user = user;
		this.password = password;
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		executeLiquibaseUpdate();
		updateDafultValue();
	}

	private void executeLiquibaseUpdate() throws SQLException, DatabaseException, LiquibaseException {
		try (java.sql.Connection connection = DriverManager.getConnection(dbConnectString, user, password)) {
			Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
			Liquibase liquibase = new liquibase.Liquibase("db-changelog5.xml", new ClassLoaderResourceAccessor(), database); //$NON-NLS-1$
			liquibase.update(new Contexts(), new LabelExpression());
		}
	}

	public void updateDafultValue() throws Exception {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");
		try (Session session = sessionFactory.openSession()) {
			
			//			String updateSort = "update %s.menu_item_test_item m set sort_order = 0";
			//			PosLog.info(getClass(), updateSort);
			//			SQLQuery query = session.createSQLQuery(String.format(updateSort, schemaName));
			//			int update = query.executeUpdate();
			//			transaction.commit();
			//			PosLog.info(getClass(), schemaName + ": updated " + update + " row");

			String selectSort = "select menu_item_id, test_item_id from %s.menu_item_test_item m";
			PosLog.info(getClass(), selectSort);
			SQLQuery selectQuery = session.createSQLQuery(String.format(selectSort, schemaName));
			List list = selectQuery.list();
			if (list != null) {
				int sort = 0;
				for (Object object : list) {
					Object[] objects = (Object[]) object;
					String menuItemId = (String) objects[0];
					String itemId = (String) objects[1];

					String updateSort = String.format("update %s.menu_item_test_item m set sort_order = %s where menu_item_id ='%s' and test_item_id='%s'",schemaName, sort++,
							menuItemId, itemId);
					Transaction transaction = session.beginTransaction();
					SQLQuery query = session.createSQLQuery(updateSort);
					int update = query.executeUpdate();
					transaction.commit();
				}
			}

		}
	}
}