package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_GENERICS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_GENERICS"
 */

public abstract class BaseMedGenerics  implements Comparable, Serializable {

	public static String REF = "MedGenerics"; //$NON-NLS-1$
	public static String PROP_THERAPUTIC_CLASS_DESC = "theraputic_class_desc"; //$NON-NLS-1$
	public static String PROP_INDICATION = "indication"; //$NON-NLS-1$
	public static String PROP_CONTRAINDICATION_DESC = "contraindication_desc"; //$NON-NLS-1$
	public static String PROP_INDICATION_DESC = "indication_desc"; //$NON-NLS-1$
	public static String PROP_SIDE_EFFECTS = "side_effects"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_DOSAGE_DESC = "dosage_desc"; //$NON-NLS-1$
	public static String PROP_INTERACTION_DESC = "interaction_desc"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PHARMACOLOGY_DESC = "pharmacology_desc"; //$NON-NLS-1$
	public static String PROP_ADMINISTRAION_DESC = "administraion_desc"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseMedGenerics () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMedGenerics (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseMedGenerics (
		java.lang.String id,
		java.lang.String name) {

		this.setId(id);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String indication;
				private java.lang.String indication_desc;
				private java.lang.String theraputic_class_desc;
				private java.lang.String pharmacology_desc;
				private java.lang.String dosage_desc;
				private java.lang.String administraion_desc;
				private java.lang.String interaction_desc;
				private java.lang.String contraindication_desc;
				private java.lang.String side_effects;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: INDICATION
	 */

	public java.lang.String getIndication () {
			return indication;
	}



	/**
	 * Set the value related to the column: INDICATION
	 * @param indication the INDICATION value
	 */
			public void setIndication (java.lang.String indication) {
			this.indication = indication;
	}



	/**
	 * Return the value associated with the column: INFICATION_DESC
	 */

	public java.lang.String getIndication_desc () {
			return indication_desc;
	}



	/**
	 * Set the value related to the column: INFICATION_DESC
	 * @param indication_desc the INFICATION_DESC value
	 */
			public void setIndication_desc (java.lang.String indication_desc) {
			this.indication_desc = indication_desc;
	}



	/**
	 * Return the value associated with the column: THERAPUTIC_CLASS_DESC
	 */

	public java.lang.String getTheraputic_class_desc () {
			return theraputic_class_desc;
	}



	/**
	 * Set the value related to the column: THERAPUTIC_CLASS_DESC
	 * @param theraputic_class_desc the THERAPUTIC_CLASS_DESC value
	 */
			public void setTheraputic_class_desc (java.lang.String theraputic_class_desc) {
			this.theraputic_class_desc = theraputic_class_desc;
	}



	/**
	 * Return the value associated with the column: PHARMACOLOGY_DESC
	 */

	public java.lang.String getPharmacology_desc () {
			return pharmacology_desc;
	}



	/**
	 * Set the value related to the column: PHARMACOLOGY_DESC
	 * @param pharmacology_desc the PHARMACOLOGY_DESC value
	 */
			public void setPharmacology_desc (java.lang.String pharmacology_desc) {
			this.pharmacology_desc = pharmacology_desc;
	}



	/**
	 * Return the value associated with the column: DOSAGE_DESC
	 */

	public java.lang.String getDosage_desc () {
			return dosage_desc;
	}



	/**
	 * Set the value related to the column: DOSAGE_DESC
	 * @param dosage_desc the DOSAGE_DESC value
	 */
			public void setDosage_desc (java.lang.String dosage_desc) {
			this.dosage_desc = dosage_desc;
	}



	/**
	 * Return the value associated with the column: ADMINISTRAION_DESC
	 */

	public java.lang.String getAdministraion_desc () {
			return administraion_desc;
	}



	/**
	 * Set the value related to the column: ADMINISTRAION_DESC
	 * @param administraion_desc the ADMINISTRAION_DESC value
	 */
			public void setAdministraion_desc (java.lang.String administraion_desc) {
			this.administraion_desc = administraion_desc;
	}



	/**
	 * Return the value associated with the column: INTERACTION_DESC
	 */

	public java.lang.String getInteraction_desc () {
			return interaction_desc;
	}



	/**
	 * Set the value related to the column: INTERACTION_DESC
	 * @param interaction_desc the INTERACTION_DESC value
	 */
			public void setInteraction_desc (java.lang.String interaction_desc) {
			this.interaction_desc = interaction_desc;
	}



	/**
	 * Return the value associated with the column: CONTRAINDICATION_DESC
	 */

	public java.lang.String getContraindication_desc () {
			return contraindication_desc;
	}



	/**
	 * Set the value related to the column: CONTRAINDICATION_DESC
	 * @param contraindication_desc the CONTRAINDICATION_DESC value
	 */
			public void setContraindication_desc (java.lang.String contraindication_desc) {
			this.contraindication_desc = contraindication_desc;
	}



	/**
	 * Return the value associated with the column: SIDE_EFFECTS
	 */

	public java.lang.String getSide_effects () {
			return side_effects;
	}



	/**
	 * Set the value related to the column: SIDE_EFFECTS
	 * @param side_effects the SIDE_EFFECTS value
	 */
			public void setSide_effects (java.lang.String side_effects) {
			this.side_effects = side_effects;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MedGenerics)) return false;
		else {
			com.floreantpos.model.MedGenerics medGenerics = (com.floreantpos.model.MedGenerics) obj;
			if (null == this.getId() || null == medGenerics.getId()) return this == obj;
			else return (this.getId().equals(medGenerics.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}