package com.floreantpos.model;

import java.util.Comparator;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCustomPayment;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;

@JsonIgnoreProperties(ignoreUnknown = true, value = {})
@XmlRootElement
public class CustomPayment extends BaseCustomPayment implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;
	private transient BankAccount linkedBankAccount;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public CustomPayment() {
	}

	/**
	 * Constructor for primary key
	 */
	public CustomPayment(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return StringUtils.isBlank(getName()) ? String.valueOf(getId()) : getName();
	}

	public void putInputFieldNameJson(String json) {
		addProperty("input.prompt.list", json); //$NON-NLS-1$
	}

	public String getInputFieldNameJson() {
		return getProperty("input.prompt.list", "[]"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public List<InputPromptModel> getInputPromptList() {
		List<InputPromptModel> inputPrompts = new Gson().fromJson(getInputFieldNameJson(), new TypeToken<List<InputPromptModel>>() {
		}.getType());

		inputPrompts.sort(Comparator.comparingInt(InputPromptModel::getSortOrder));
		return inputPrompts;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public Boolean isLinkWithBankAccount() {
		return getBooleanProperty("link_with_bank_account", false);
	}

	public void putLinkWithBankAccount(boolean enable) {
		addProperty("link_with_bank_account", String.valueOf(enable));
	}

	public BankAccount getLinkedBankAccount() {
		return linkedBankAccount;
	}

	public void setLinkedBankAccount(BankAccount bankAccountTo) {
		this.linkedBankAccount = bankAccountTo;
	}

}