package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum TimeType {

	//@formatter:off
	HOUR("Hour"),
	DAY("Day"),
	;
	//@formatter:on

	private final String timeType;

	public String getTimeType() {
		return timeType;
	}

	private TimeType(String timeType) {
		this.timeType = timeType;
	}

	public static TimeType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return HOUR;
		}

		TimeType[] values = values();
		for (TimeType timeType : values) {
			if (name.equals(timeType.name())) {
				return timeType;
			}
		}

		return HOUR;
	}

	@Override
	public String toString() {
		return timeType;
	}

}
