package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the GRATUITY_PAYMENT_HISTORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="GRATUITY_PAYMENT_HISTORY"
 */

public abstract class BaseGratuityPaymentHistory  implements Comparable, Serializable {

	public static String REF = "GratuityPaymentHistory"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TIME = "transactionTime"; //$NON-NLS-1$
	public static String PROP_TENDERED_AMOUNT = "tenderedAmount"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_CASH_DRAWER = "cashDrawer"; //$NON-NLS-1$
	public static String PROP_PAID_BY = "paidBy"; //$NON-NLS-1$
	public static String PROP_STORE_SESSION_ID = "storeSessionId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_GRATUITY = "gratuity"; //$NON-NLS-1$


	// constructors
	public BaseGratuityPaymentHistory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseGratuityPaymentHistory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseGratuityPaymentHistory (
		java.lang.String id,
		com.floreantpos.model.CashDrawer cashDrawer) {

		this.setId(id);
		this.setCashDrawer(cashDrawer);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date transactionTime;
				private java.lang.Double amount;
				private java.lang.Double tenderedAmount;
				private java.lang.String storeSessionId;
				private java.lang.String outletId;
	
	// many to one
	private com.floreantpos.model.Gratuity gratuity;
	private com.floreantpos.model.CashDrawer cashDrawer;
	private com.floreantpos.model.User paidBy;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TIME
	 */

	public java.util.Date getTransactionTime () {
			return transactionTime;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TIME
	 * @param transactionTime the TRANSACTION_TIME value
	 */
			public void setTransactionTime (java.util.Date transactionTime) {
			this.transactionTime = transactionTime;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: TENDERED_AMOUNT
	 */

	public java.lang.Double getTenderedAmount () {
						return tenderedAmount == null ? Double.valueOf(0) : tenderedAmount;
		}



	/**
	 * Set the value related to the column: TENDERED_AMOUNT
	 * @param tenderedAmount the TENDERED_AMOUNT value
	 */
			public void setTenderedAmount (java.lang.Double tenderedAmount) {
			this.tenderedAmount = tenderedAmount;
	}



	/**
	 * Return the value associated with the column: STORE_SESSION_ID
	 */

	public java.lang.String getStoreSessionId () {
			return storeSessionId;
	}



	/**
	 * Set the value related to the column: STORE_SESSION_ID
	 * @param storeSessionId the STORE_SESSION_ID value
	 */
			public void setStoreSessionId (java.lang.String storeSessionId) {
			this.storeSessionId = storeSessionId;
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: GRATUITY_ID
	 */

	public com.floreantpos.model.Gratuity getGratuity () {
			return gratuity;
	}



	/**
	 * Set the value related to the column: GRATUITY_ID
	 * @param gratuity the GRATUITY_ID value
	 */
			public void setGratuity (com.floreantpos.model.Gratuity gratuity) {
			this.gratuity = gratuity;
	}



	/**
	 * Return the value associated with the column: CASH_DRAWER_ID
	 */

	public com.floreantpos.model.CashDrawer getCashDrawer () {
			return cashDrawer;
	}



	/**
	 * Set the value related to the column: CASH_DRAWER_ID
	 * @param cashDrawer the CASH_DRAWER_ID value
	 */
			public void setCashDrawer (com.floreantpos.model.CashDrawer cashDrawer) {
			this.cashDrawer = cashDrawer;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public com.floreantpos.model.User getPaidBy () {
			return paidBy;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param paidBy the OUTLET_ID value
	 */
			public void setPaidBy (com.floreantpos.model.User paidBy) {
			this.paidBy = paidBy;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.GratuityPaymentHistory)) return false;
		else {
			com.floreantpos.model.GratuityPaymentHistory gratuityPaymentHistory = (com.floreantpos.model.GratuityPaymentHistory) obj;
			if (null == this.getId() || null == gratuityPaymentHistory.getId()) return this == obj;
			else return (this.getId().equals(gratuityPaymentHistory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}