/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import com.floreantpos.report.UserWiseCollectionReportData;
import com.floreantpos.swing.ListTableModel;

public class UserWiseCollectionReportDataModel extends ListTableModel {

	public UserWiseCollectionReportDataModel() {
		setColumnNames(
				new String[] { "sl", "orderId", "date", "name", "subTotal", "discount", "total", "advanced", "due", "vat", "totalReceived", "userName" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		UserWiseCollectionReportData data = (UserWiseCollectionReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return data.getSerialNumber();

			case 1:
				return data.getOrderId();

			case 2:
				return data.getOrderDate();

			case 3:
				return data.getPatientName();

			case 4:
				return data.getSubTotalAmount();

			case 5:
				return data.getDiscount();

			case 6:
				return data.getTotalAmount();

			case 7:
				return data.getAdvancedAmount();

			case 8:
				return data.getDueColl();

			case 9:
				return data.getVatAmount();

			case 10:
				return data.getTotalReceived();

			case 11:
				return data.getUserName();

		}
		return null;
	}

}
