/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.util.DataProvider;

public class UpdateDBTo461 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo461(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		DataProvider.get().initialize();
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$
		updateTicketItems();
		updateComboTicketItems();
	}

	public void updateTicketItems() {
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			//@formatter:off

			String hqlString = "update " + schemaName + ".ticket_item "
					+ "set "
						+ "parent_ticket_id = ticket_id, "
						+ "parent_ticket_outlet_id = outlet_id "
					+ "where "
						+ "combo_child = false"
					;
			//@formatter:on

			SQLQuery sqlQuery = session.createSQLQuery(hqlString); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			PosLog.info(getClass(), "updated query: " + sqlQuery + ""); //$NON-NLS-1$ //$NON-NLS-2$
			int update = sqlQuery.executeUpdate();
			PosLog.info(getClass(), "updated " + update + " ticket item"); //$NON-NLS-1$ //$NON-NLS-2$
			transaction.commit();
		}

	}

	public void updateComboTicketItems() {
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			//@formatter:off

			String hqlString = "update " + schemaName + ".ticket_item as child "
					+ "set "
						+ "parent_ticket_id = parent.ticket_id, "
						+ "parent_ticket_outlet_id = parent.outlet_id "
					+ "from "
						+ "ticket_item as parent "
					+ "where "
						+ "child.combo_child = true "
						+ "and "
						+ "child.parent_ticket_item_id = parent.id"
					;
			//@formatter:on

			SQLQuery sqlQuery = session.createSQLQuery(hqlString); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			PosLog.info(getClass(), "updated query: " + sqlQuery + ""); //$NON-NLS-1$ //$NON-NLS-2$
			int update = sqlQuery.executeUpdate();
			PosLog.info(getClass(), "updated " + update + " combo ticket item"); //$NON-NLS-1$ //$NON-NLS-2$
			transaction.commit();
		}

	}

}