/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.ui.views.payment;

import java.util.List;
import java.util.Map;

import com.floreantpos.extension.PaymentMethod;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;

public interface CardProcessor {
	public void preAuth(PosTransaction transaction) throws Exception;

	public default void preAuth(PosTransaction transaction, PaymentMethod paymentMethod) throws Exception {
		preAuth(transaction);
	}

	public default void preAuth(PosTransaction transaction, PaymentMethod paymentMethod, boolean checkDuplicate) throws Exception {
		preAuth(transaction, paymentMethod);
	}

	public default Map<String, Object> saveCreditCardInfo(String customerId, String customerEmail, String cardHolderName, String cardNumber, String expMonth,
			String expYear, String cvv) throws Exception {
		return null;
	}

	public default List<PaymentMethod> getPaymentMethods(Customer customer) throws Exception {
		return null;
	}

	public default void removeCard(PaymentMethod paymentMethod, Customer customer) throws Exception {
	}

	public void captureAuthAmount(PosTransaction transaction) throws Exception;

	public void chargeAmount(PosTransaction transaction) throws Exception;

	public default void chargeAmount(PosTransaction transaction, PaymentMethod paymentMethod, Boolean saveCard) throws Exception {
		chargeAmount(transaction);
	}

	public void voidTransaction(PosTransaction transaction) throws Exception;

	public void refundTransaction(PosTransaction transaction, double refundAmount) throws Exception;

	public String getCardInformationForReceipt(PosTransaction transaction);

	public void cancelTransaction();

	public default void closeBatch(Terminal terminal) {

	}

	public default void closeBatch(Terminal terminal, User performer) {

	}

	public default boolean isAllowPartialPayment() {
		return true;
	}

	public default void setAllowPartialPayment(boolean allow) {

	}

	public default String getProfileKey() {
		return "";
	}

}
