package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseInventoryStock;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "conversionValue", "unit", "menuItem", "inventoryLocation", "outlet" })
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class InventoryStock extends BaseInventoryStock implements TimedModel {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public InventoryStock() {
	}

	/**
	 * Constructor for primary key
	 */
	public InventoryStock(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	private double menuItemCost;
	private String locationName;

	private InventoryLocation inventoryLocation;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private String unitCodeDisplay;

	private double salesUnit;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void setUnitName(String name) {

	}

	public String getUnitName() {
		IUnit unitByCode = DataProvider.get().getUnitById(getUnit(), getUnitType());
		if (unitByCode != null) {
			return unitByCode.getName();
		}
		return null;
	}

	public String getSku() {
		String skuDisplay = super.getSku();
		return StringUtils.isNotEmpty(skuDisplay) ? skuDisplay : ""; //$NON-NLS-1$
	}

	public void setMenuItem(MenuItem menuItem) {
		if (menuItem == null)
			return;
		setMenuItemId(menuItem.getId());
		setItemName(menuItem.getDisplayName());
		setSku(menuItem.getSku());
	}

	@XmlTransient
	public Outlet getOutlet() {
		if (StringUtils.isBlank(getOutletId())) {
			return null;
		}
		return OutletDAO.getInstance().get(getOutletId());
	}

	public void setOutlet(Outlet outlet) {
		setOutletId(outlet == null ? null : outlet.getId());
	}

	public InventoryLocation getInventoryLocation() {
		String locationId = getLocationId();
		if (locationId == null)
			return null;
		if (inventoryLocation != null && inventoryLocation.getId().equals(locationId))
			return inventoryLocation;
		return DataProvider.get().getInventoryLocationById(locationId, getOutletId());
	}

	public void setInventoryLocation(InventoryLocation inventoryLocation) {
		this.inventoryLocation = inventoryLocation;
	}

	public double getMenuItemCost() {
		return menuItemCost;
	}

	public void setMenuItemCost(double menuItemCost) {
		this.menuItemCost = menuItemCost;
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	@JsonIgnore
	@XmlTransient
	public MenuItem getMenuItem() {
		if (StringUtils.isEmpty(getMenuItemId())) {
			return null;
		}
		return (MenuItem) DataProvider.get().getObjectOf(MenuItem.class, getMenuItemId());
	}

	public String getUnitCodeDisplay() {
		return unitCodeDisplay;
	}

	public void setUnitCodeDisplay(String unitCodeDisplay) {
		this.unitCodeDisplay = unitCodeDisplay;
	}

	public String getDueDateAsString() {
		if (super.getExpireDate() == null) {
			return ""; //$NON-NLS-1$
		}
		return DateUtil.formatAsShortDate(DateUtil.convertServerTimeToBrowserTime(super.getExpireDate()));
	}

	public double getSalesUnit() {
		return salesUnit;
	}

	public void setSalesUnit(double salesUnit) {
		this.salesUnit = salesUnit;
	}

	@Override
	public String toString() {
		return getBatchNumber();
	}

	public void setOutletDisplay(String outletId) {
	}

	@JsonIgnore
	@XmlTransient
	public String getOutletDisplay() {
		InventoryLocation toInventoryLocation = getInventoryLocation();
		Outlet outlet = null;
		if (StringUtils.isNotBlank(getOutletId())) {
			outlet = DataProvider.get().getOutlet();
			if (!getOutletId().equals(outlet.getId())) {
				outlet = (Outlet) DataProvider.get().getObjectOf(Outlet.class, getOutletId());
			}
		}
		if (outlet != null && toInventoryLocation != null) {
			return outlet.getName() + "-> " + toInventoryLocation.getName();
		}
		else if (toInventoryLocation != null) {
			return toInventoryLocation.getName();
		}
		else if (outlet != null) {
			return outlet.getName();
		}
		return null;
	}

	public void setTotalCost(Double d) {

	}

	public Double getTotalCost() {
		return getQuantityInHand() * getUnitCost();
	}

	public void setTotalPrice(Double d) {

	}

	public Double getTotalPrice() {
		return getQuantityInHand() * getUnitPrice();
	}

	public String getInHandQtyWithUnitDisplay() {
		StringBuilder builder = new StringBuilder();
		builder.append(NumberUtil.formatNumberIfNeeded(getQuantityInHand()));
		if (getUnitCodeDisplay() != null) {
			builder.append(" ");
			builder.append(getUnitCodeDisplay());
		}
		return builder.toString();
	}
}