package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseBankAccount;

public class BankAccount extends BaseBankAccount implements TimedModel {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BankAccount() {
	}

	/**
	 * Constructor for primary key
	 */
	public BankAccount(java.lang.String id) {
		super(id);
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}
	/*[CONSTRUCTOR MARKER END]*/

	public String getDisplayString() {
		String accountNo = getAccountNo();
		if (StringUtils.isNotBlank(accountNo)) {
			accountNo = accountNo.replaceAll("(\\d{2})\\d+(\\d{4})", "$1****$2");
		}
		return getBankName() + " (" + accountNo + ")";
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}