/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.ext.KitchenStatus;

public class KitchenTicketItem extends BaseKitchenTicketItem {
	private static final long serialVersionUID = 1L;

	private String voidedItemId;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public KitchenTicketItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public KitchenTicketItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isInformationOnly() {
		return isSeat() || isCookingInstruction();
	}

	public KitchenStatus getKitchenStatusValue() {
		return KitchenStatus.fromString(super.getStatus());
	}

	public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
		super.setStatus(kitchenStatus.name());
	}

	public java.lang.String getMenuItemGroupName() {
		if (super.getMenuItemGroupName() == null) {
			return ""; //$NON-NLS-1$
		}
		return super.getMenuItemGroupName();
	}

	public String getVoidedItemId() {
		return voidedItemId;
	}

	public void setVoidedItemId(String voidedItemId) {
		this.voidedItemId = voidedItemId;
	}

	public String getMenuItemNameDisplay() {
		if (isInformationOnly()) {
			return getMenuItemName();
		}
		if (isModifierItem()) {
			return "    " + getMenuItemName() + "*"; //$NON-NLS-1$ //$NON-NLS-2$
		}
		String nameDisplay = ""; //$NON-NLS-1$
		if (StringUtils.isNotEmpty(getCourseName())) {
			nameDisplay = "[" + getCourseName() + "] "; //$NON-NLS-1$ //$NON-NLS-2$
		}
		String itemName = getMenuItemName();
		//		if (getQuantity() > 1) {
		//			nameDisplay += NumberUtil.trimDecilamIfNotNeeded(getQuantity()) + "x "; //$NON-NLS-1$
		//		}
		return nameDisplay += itemName;
	}
}