package io.github.escposjava.print;

import com.floreantpos.PosLog;

import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialPortPrinter implements Printer {
	private String port;
	private SerialPort serialPort;

	public SerialPortPrinter(String port) {
		this.port = port;
	}

	public void open() {
		serialPort = new SerialPort(port);
		try {
			serialPort.openPort();
			serialPort.setParams(SerialPort.BAUDRATE_9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (SerialPortException ex) {
		}
	}

	public boolean isConnected() {
		return serialPort != null && serialPort.isOpened();
	}

	public void write(byte[] command) {
		try {
			serialPort.writeBytes(command);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public void close() {
		try {
			serialPort.closePort();
		} catch (SerialPortException ex) {
			PosLog.error(getClass(), ex);
		}
	}

}
