package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum OutdoorConfigurationFeeType {
	FixedOutdoorFee, VariableOutdoorFeeforEachDoctor;

	public static OutdoorConfigurationFeeType fromName(String name) {
		if (StringUtils.isEmpty(name)) {
			return OutdoorConfigurationFeeType.FixedOutdoorFee;
		}

		OutdoorConfigurationFeeType[] values = values();
		for (OutdoorConfigurationFeeType chargeType : values) {
			if (name.equals(chargeType.name())) {
				return chargeType;
			}
		}

		return OutdoorConfigurationFeeType.FixedOutdoorFee;
	}
}