/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;

import com.floreantpos.PosLog;

public class UpdateDBTo343 {

	private SessionFactory sessionFactory;
	private String schemaName;

	//	private String dbConnectString;
	//	private String user;
	//	private String password;
	//	private String schemaName;
	//
	//	public UpdateDBTo343(String dbConnectString, String user, String password, String schemaName) {
	//		this.dbConnectString = dbConnectString;
	//		this.user = user;
	//		this.password = password;
	//		this.schemaName = schemaName;
	//	}

	public UpdateDBTo343(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {

		sessionFactory.openSession().doWork(new Work() {
			@Override
			public void execute(Connection connection) throws SQLException {
				ledgerEntryPatientIdChangeToRecepientId(connection);
			}
		});

	}

	public void ledgerEntryPatientIdChangeToRecepientId(Connection connection) throws SQLException {
		PosLog.info(getClass(), "Updating : " + schemaName + " schema.");
		Statement updateQueryStatement = connection.createStatement();
		updateQueryStatement.execute(String.format("UPDATE %s.ledger_entry SET RECEPIENT_ID = PATIENT_ID WHERE PATIENT_ID is not null", schemaName));
//		updateQueryStatement.execute(String.format("UPDATE %s.ledger_entry SET PATIENT_ID = null", schemaName));
		//updateQueryStatement.execute(String.format("ALTER TABLE %s.ledger_entry DROP COLUMN PATIENT_ID", schemaName));
		connection.commit();
	}

	//	public void update() throws Exception {
	//	executeLiquibaseUpdate();
	//	}

	//	private void executeLiquibaseUpdate() throws SQLException, DatabaseException, LiquibaseException {
	//		try (java.sql.Connection connection = DriverManager.getConnection(dbConnectString, user, password)) {
	//			Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
	//			if (!schemaName.equals("public")) {
	//				database.setDefaultSchemaName(schemaName);
	//			}
	//
	//			Liquibase liquibase = new liquibase.Liquibase("db-changelog7.xml", new ClassLoaderResourceAccessor(), database); //$NON-NLS-1$
	//			liquibase.update(new Contexts(), new LabelExpression());
	//		}
	//	}
}