package com.floreantpos.model;

import java.util.Date;

import com.floreantpos.POSConstants;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;

public class Comment {
	private UserType userType;
	private String userId;
	private Date time;
	private String message;

	public Comment(UserType userType, String userId, Date time, String message) {
		this.userType = userType;
		this.userId = userId;
		this.time = time;
		this.message = message;
	}

	public UserType getUserType() {
		return userType;
	}

	public void setUserType(UserType userType) {
		this.userType = userType;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getAuthor() {
		if (UserType.USER == userType) {
			User user = DataProvider.get().getUserById(userId, DataProvider.get().getOutletId());
			if (user == null) {
				return POSConstants.USER;
			}
			return user.getFullName();
		}

		Customer customer = DataProvider.get().getCustomer(userId);
		if (customer == null) {
			return POSConstants.CUSTOMER;
		}
		return customer.getName();
	}

	public String getTimeAgo() {
		return DateUtil.formatFullDateAndTimeAsString(time);
	}

	public Date getTime() {
		return time;
	}

	public void setTime(Date time) {
		this.time = time;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public enum UserType {
		USER, CUSTOMER
	}
}
