package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the BANK_ACCOUNT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="BANK_ACCOUNT"
 */

public abstract class BaseBankAccount  implements Serializable {

	public static String REF = "BankAccount"; //$NON-NLS-1$
	public static String PROP_BANK_NAME = "bankName"; //$NON-NLS-1$
	public static String PROP_BANK_PHONE = "bankPhone"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_EMAIL = "email"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_NO = "accountNo"; //$NON-NLS-1$
	public static String PROP_BANK_ADDRESS = "bankAddress"; //$NON-NLS-1$
	public static String PROP_DE_ACTIVATION_DATE = "deActivationDate"; //$NON-NLS-1$
	public static String PROP_MINIMUM_BALANCE = "minimumBalance"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_TYPE = "accountType"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_BANK_BRANCH = "bankBranch"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ACTIVATION_DATE = "activationDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_BALANCE = "balance"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_NAME = "accountName"; //$NON-NLS-1$


	// constructors
	public BaseBankAccount () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseBankAccount (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createDate;
				private java.lang.String bankName;
				private java.lang.String bankAddress;
				private java.lang.String bankBranch;
				private java.lang.String bankPhone;
				private java.lang.String accountName;
				private java.lang.String accountNo;
				private java.lang.String accountType;
				private java.lang.String email;
				private java.lang.Double minimumBalance;
				private java.lang.Double balance;
				private java.util.Date activationDate;
				private java.util.Date deActivationDate;
				private java.lang.Boolean active;
				private java.lang.Boolean deleted;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: BANK_NAME
	 */

	public java.lang.String getBankName () {
			return bankName;
	}



	/**
	 * Set the value related to the column: BANK_NAME
	 * @param bankName the BANK_NAME value
	 */
			public void setBankName (java.lang.String bankName) {
			this.bankName = bankName;
	}



	/**
	 * Return the value associated with the column: BANK_ADDRESS
	 */

	public java.lang.String getBankAddress () {
			return bankAddress;
	}



	/**
	 * Set the value related to the column: BANK_ADDRESS
	 * @param bankAddress the BANK_ADDRESS value
	 */
			public void setBankAddress (java.lang.String bankAddress) {
			this.bankAddress = bankAddress;
	}



	/**
	 * Return the value associated with the column: BANK_BRANCH
	 */

	public java.lang.String getBankBranch () {
			return bankBranch;
	}



	/**
	 * Set the value related to the column: BANK_BRANCH
	 * @param bankBranch the BANK_BRANCH value
	 */
			public void setBankBranch (java.lang.String bankBranch) {
			this.bankBranch = bankBranch;
	}



	/**
	 * Return the value associated with the column: BANK_PHONE
	 */

	public java.lang.String getBankPhone () {
			return bankPhone;
	}



	/**
	 * Set the value related to the column: BANK_PHONE
	 * @param bankPhone the BANK_PHONE value
	 */
			public void setBankPhone (java.lang.String bankPhone) {
			this.bankPhone = bankPhone;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_NAME
	 */

	public java.lang.String getAccountName () {
			return accountName;
	}



	/**
	 * Set the value related to the column: ACCOUNT_NAME
	 * @param accountName the ACCOUNT_NAME value
	 */
			public void setAccountName (java.lang.String accountName) {
			this.accountName = accountName;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_NO
	 */

	public java.lang.String getAccountNo () {
			return accountNo;
	}



	/**
	 * Set the value related to the column: ACCOUNT_NO
	 * @param accountNo the ACCOUNT_NO value
	 */
			public void setAccountNo (java.lang.String accountNo) {
			this.accountNo = accountNo;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_TYPE
	 */

	public java.lang.String getAccountType () {
			return accountType;
	}



	/**
	 * Set the value related to the column: ACCOUNT_TYPE
	 * @param accountType the ACCOUNT_TYPE value
	 */
			public void setAccountType (java.lang.String accountType) {
			this.accountType = accountType;
	}



	/**
	 * Return the value associated with the column: EMAIL
	 */

	public java.lang.String getEmail () {
			return email;
	}



	/**
	 * Set the value related to the column: EMAIL
	 * @param email the EMAIL value
	 */
			public void setEmail (java.lang.String email) {
			this.email = email;
	}



	/**
	 * Return the value associated with the column: MINIMUM_BALANCE
	 */

	public java.lang.Double getMinimumBalance () {
						return minimumBalance == null ? Double.valueOf(0) : minimumBalance;
		}



	/**
	 * Set the value related to the column: MINIMUM_BALANCE
	 * @param minimumBalance the MINIMUM_BALANCE value
	 */
			public void setMinimumBalance (java.lang.Double minimumBalance) {
			this.minimumBalance = minimumBalance;
	}



	/**
	 * Return the value associated with the column: BALANCE
	 */

	public java.lang.Double getBalance () {
						return balance == null ? Double.valueOf(0) : balance;
		}



	/**
	 * Set the value related to the column: BALANCE
	 * @param balance the BALANCE value
	 */
			public void setBalance (java.lang.Double balance) {
			this.balance = balance;
	}



	/**
	 * Return the value associated with the column: ACTIVATION_DATE
	 */

	public java.util.Date getActivationDate () {
			return activationDate;
	}



	/**
	 * Set the value related to the column: ACTIVATION_DATE
	 * @param activationDate the ACTIVATION_DATE value
	 */
			public void setActivationDate (java.util.Date activationDate) {
			this.activationDate = activationDate;
	}



	/**
	 * Return the value associated with the column: DEACTIVATION_DATE
	 */

	public java.util.Date getDeActivationDate () {
			return deActivationDate;
	}



	/**
	 * Set the value related to the column: DEACTIVATION_DATE
	 * @param deActivationDate the DEACTIVATION_DATE value
	 */
			public void setDeActivationDate (java.util.Date deActivationDate) {
			this.deActivationDate = deActivationDate;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */

	public java.lang.Boolean isActive () {
					return active == null ? Boolean.FALSE : active;
		}

	public java.lang.Boolean getActive () {
				return active == null ? Boolean.FALSE : active;
			}


	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.BankAccount)) return false;
		else {
			com.floreantpos.model.BankAccount bankAccount = (com.floreantpos.model.BankAccount) obj;
			if (null == this.getId() || null == bankAccount.getId()) return this == obj;
			else return (this.getId().equals(bankAccount.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}