package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.DeliveryCharge;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class DeliveryChargeDAO extends BaseDeliveryChargeDAO {
	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public List<DeliveryCharge> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	@Override
	protected void delete(Object obj, Session session) {
		DeliveryCharge bean = (DeliveryCharge) obj;
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	public List<DeliveryCharge> findByDistance(double distance) {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(
					Restrictions.and(Restrictions.le(DeliveryCharge.PROP_START_RANGE, distance), Restrictions.ge(DeliveryCharge.PROP_END_RANGE, distance)));
			addDeletedFilter(criteria);
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public List<DeliveryCharge> findByZipCode(String zipCode) {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(DeliveryCharge.PROP_ZIP_CODE, zipCode));
			addDeletedFilter(criteria);
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public double findMinRange() {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.min(DeliveryCharge.PROP_START_RANGE));
			addDeletedFilter(criteria);
			return (Double) criteria.uniqueResult();
		} finally {
			closeSession(session);
		}
	}

	public Double findMaxRange() {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.max(DeliveryCharge.PROP_END_RANGE));
			addDeletedFilter(criteria);
			return (Double) criteria.uniqueResult();
		} finally {
			closeSession(session);
		}
	}

	public void saveOrUpdateDeliveryChargeList(List<DeliveryCharge> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<DeliveryCharge> iterator = dataList.iterator(); iterator.hasNext();) {
				DeliveryCharge item = (DeliveryCharge) iterator.next();
				DeliveryCharge existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getName() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}
}