package com.floreantpos.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseDoctor;
import com.floreantpos.model.dao.OutdoorDoctorProfileDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "propertiesContainer" })
public class Doctor extends BaseDoctor {
	private static final long serialVersionUID = 1L;
	private transient OutdoorDoctorProfile doctorProfile;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Doctor () {
    }

	/**
	 * Constructor for primary key
	 */
	public Doctor (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getDoctorTypeDisplayName() {
		if (StringUtils.isBlank(getId())) {
			return null;
		}
		if (getIndorDoctor()) {
			return AgentTypeEnum.INDOOR_DOCTOR.getDisplayString();
		}
		return AgentTypeEnum.OUTDOOR_DOCTOR.getDisplayString();
	}

	public void setDoctorProfile(OutdoorDoctorProfile doctorProfile) {
		this.doctorProfile = doctorProfile;
	}

	public OutdoorDoctorProfile getDoctorProfile() {
		if (doctorProfile != null) {
			return doctorProfile;
		}
		if (doctorProfile == null && super.getId() != null) {
			String outletId = DataProvider.get().getOutletId();
			doctorProfile = OutdoorDoctorProfileDAO.getInstance().getProfile(getId(), outletId);
		}
		return doctorProfile;
	}

	@XmlTransient
	@JsonIgnore
	public List<DoctorTimeSchedule> getSchedules(String outletId) {
		if (StringUtils.isBlank(outletId)) {
			return Collections.emptyList();
		}
		if (super.getId() == null) {
			return Collections.emptyList();
		}
		if (doctorProfile == null) {
			doctorProfile = OutdoorDoctorProfileDAO.getInstance().getProfile(getId(), outletId);
		}
		if (doctorProfile != null) {
			return doctorProfile.getSchedules();
		}
		return Collections.emptyList();
	}

	@XmlTransient
	@JsonIgnore
	public List<DoctorTimeSchedule> getSchedules() {
		if (super.getId() == null) {
			return new ArrayList<>();
		}
		if (doctorProfile == null) {
			String outletId = DataProvider.get().getOutletId();
			doctorProfile = OutdoorDoctorProfileDAO.getInstance().getProfile(getId(), outletId);
		}
		if (doctorProfile != null) {
			return doctorProfile.getSchedules();
		}
		return new ArrayList<>();
	}

	public void setSchedules(List<DoctorTimeSchedule> schedules) {
		if (schedules == null) {
			schedules = new ArrayList<>();
		}
		if (doctorProfile == null) {
			String outletId = DataProvider.get().getOutletId();
			doctorProfile = OutdoorDoctorProfileDAO.getInstance().getProfile(getId(), outletId);
		}
		if (doctorProfile != null) {
			doctorProfile.setSchedules(schedules);
		}
		setHasSchedule(schedules.size() > 0);
	}

	public void addOrUpdateSchedule(DoctorTimeSchedule schedule) {
		boolean dataExists = false;
		List<DoctorTimeSchedule> schedules = getSchedules();
		if (schedule.getId() != null && schedules != null && schedules.size() > 0) {
			for (DoctorTimeSchedule doctorTimeSchedule : schedules) {
				if (doctorTimeSchedule.getId() != null && doctorTimeSchedule.getId().equalsIgnoreCase(schedule.getId())) {
					doctorTimeSchedule.setConsultationTime(schedule.getConsultationTime());
					doctorTimeSchedule.setConsultationFees(schedule.getConsultationFees());
					doctorTimeSchedule.setDays(schedule.getDays());
					doctorTimeSchedule.setEndTime(schedule.getEndTime());
					doctorTimeSchedule.setPatientCount(schedule.getPatientCount());
					doctorTimeSchedule.setShiftName(schedule.getShiftName());
					doctorTimeSchedule.setStartTime(schedule.getStartTime());
					doctorTimeSchedule.setPatientCount(schedule.getPatientCount());
					doctorTimeSchedule.setOutdoorFee(schedule.getOutdoorFee());
					doctorTimeSchedule.setRevisitFee(schedule.getRevisitFee());
					doctorTimeSchedule.setDoctorChargeRate(schedule.getDoctorChargeRate());
					doctorTimeSchedule.setDoctorChargeType(schedule.getDoctorChargeType());
					doctorTimeSchedule.setRevisitInterval(schedule.getRevisitInterval());
					doctorTimeSchedule.setRevisitDurationType(schedule.getRevisitDurationType());
					dataExists = true;
					break;
				}
			}
		}
		if (!dataExists) {
			if (schedules == null) {
				schedules = new ArrayList<>();
			}
			if (StringUtils.isBlank(schedule.getId())) {
			}
			schedule.setId(GlobalIdGenerator.generateGlobalId());
			schedules.add(schedule);
		}
		setSchedules(schedules);
	}

	@XmlTransient
	@JsonIgnore
	public Boolean isAllowDigitalSignature() {
		return POSUtil.getBoolean(getProperty("allowDigitalSignature"), false); //$NON-NLS-1$
	}

	public void setAllowDigitalSignature(boolean enableDigitalSignature) {
		addProperty("allowDigitalSignature", String.valueOf(enableDigitalSignature)); //$NON-NLS-1$
	}

}