package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DECLARED_TIPS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DECLARED_TIPS"
 */

public abstract class BaseDeclaredTips  implements Comparable, Serializable {

	public static String REF = "DeclaredTips"; //$NON-NLS-1$
	public static String PROP_SESSION_ID = "sessionId"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_OWNER_ID = "ownerId"; //$NON-NLS-1$
	public static String PROP_DECLARED_TIME = "declaredTime"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$


	// constructors
	public BaseDeclaredTips () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDeclaredTips (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Double amount;
				private java.util.Date declaredTime;
				private java.lang.String ownerId;
				private java.lang.String sessionId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
				public long getVersion () {
						return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
				public java.util.Date getLastUpdateTime () {
						return lastUpdateTime;
			}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
				public java.util.Date getLastSyncTime () {
						return lastSyncTime;
			}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */
				public java.lang.Double getAmount () {
										return amount == null ? Double.valueOf(0) : amount;
					}

	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: DECLARED_TIME
	 */
				public java.util.Date getDeclaredTime () {
						return declaredTime;
			}

	/**
	 * Set the value related to the column: DECLARED_TIME
	 * @param declaredTime the DECLARED_TIME value
	 */
			public void setDeclaredTime (java.util.Date declaredTime) {
			this.declaredTime = declaredTime;
	}



	/**
	 * Return the value associated with the column: OWNER_ID
	 */
				public java.lang.String getOwnerId () {
						return ownerId;
			}

	/**
	 * Set the value related to the column: OWNER_ID
	 * @param ownerId the OWNER_ID value
	 */
			public void setOwnerId (java.lang.String ownerId) {
			this.ownerId = ownerId;
	}



	/**
	 * Return the value associated with the column: SESSION_ID
	 */
				public java.lang.String getSessionId () {
						return sessionId;
			}

	/**
	 * Set the value related to the column: SESSION_ID
	 * @param sessionId the SESSION_ID value
	 */
			public void setSessionId (java.lang.String sessionId) {
			this.sessionId = sessionId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DeclaredTips)) return false;
		else {
			com.floreantpos.model.DeclaredTips declaredTips = (com.floreantpos.model.DeclaredTips) obj;
			if (null == this.getId() || null == declaredTips.getId()) return this == obj;
			else return (this.getId().equals(declaredTips.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}