package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

import com.floreantpos.PosLog;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class StoreSessionControlDAO extends BaseStoreSessionControlDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public StoreSessionControlDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public StoreSessionControl getCurrent() {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.addOrder(Order.asc(StoreSessionControl.PROP_ID));
			List list = criteria.list();
			if (list == null || list.size() == 0) {
				StoreSessionControl storeSessionControl = new StoreSessionControl();
				save(storeSessionControl);
				return storeSessionControl;
			}
			return (StoreSessionControl) list.get(0);
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

	public void saveOrUpdateStoreSessionControl(List dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator iterator = dataList.iterator(); iterator.hasNext();) {
				StoreSessionControl item = (StoreSessionControl) iterator.next();
				StoreSessionControl existingItem = get(item.getId());
				StoreSession currentStoreSession = item.getCurrentData();

				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getId() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					if (currentStoreSession != null) {
						existingItem.setCurrentData(currentStoreSession);
					}
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}
}